/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.app;

import com.jslope.client.account.CreateAccountDialog;
import com.jslope.client.app.Icons;
import com.jslope.client.app.MessageReceiver;
import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.tree.TreePanel;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.model.AccountNode;
import com.jslope.client.ui.model.Application;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.model.DirectoryTreeModel;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.security.SecureID;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class Actions {
    public static Action checkMailForAllAccounts;
    public static Action checkMailForAccount;
    public static Action createNewAccount;
    public static Action deleteAccount;
    public static Action saveAccountID;
    public static Action launchDomainManager;
    public static Action createNewMessage;
    public static Action deleteMessage;
    public static Action replyToMessage;
    public static Action openMessage;
    public static Action saveOneAttachment;
    public static Action saveAllAttachments;
    public static Action deleteAttachment;

    public static void setPermission(DirectoryAccountTreeNode node) {
        createNewMessage.setEnabled(node.canCreateNewMessage());
        checkMailForAccount.setEnabled(node.canCheckMailForAnAccount());
        checkMailForAllAccounts.setEnabled(node.canCheckMailForAllAccounts());
        deleteAccount.setEnabled(node.canDeleteAnAccount());
        Actions.setMessageIsSelected(Application.isMessageSelected());
    }

    public static void setMessageIsSelected(boolean value) {
        replyToMessage.setEnabled(value);
        deleteMessage.setEnabled(value);
    }

    private static void errorMessage(String message) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), message);
    }

    static {
        createNewMessage = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.createNewMessage();
            }
        };
        createNewMessage.putValue("Name", "New");
        createNewMessage.putValue("ShortDescription", "Create new message");
        createNewMessage.putValue("MnemonicKey", 78);
        createNewMessage.putValue("SmallIcon", Icons.newMessage);
        deleteMessage = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.deleteCurrentMessage();
            }
        };
        deleteMessage.putValue("Name", "Delete");
        deleteMessage.putValue("ShortDescription", "Delete message");
        deleteMessage.putValue("MnemonicKey", 68);
        deleteMessage.putValue("SmallIcon", Icons.delete);
        deleteMessage.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        replyToMessage = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Replying to message...");
                Application.replyToMessage();
            }
        };
        replyToMessage.putValue("Name", "Reply");
        replyToMessage.putValue("ShortDescription", "Reply to message");
        replyToMessage.putValue("MnemonicKey", 82);
        replyToMessage.putValue("SmallIcon", Icons.replyMail);
        replyToMessage.setEnabled(false);
        openMessage = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Open message...");
                Application.openMessage();
            }
        };
        openMessage.putValue("Name", "Open");
        openMessage.putValue("ShortDescription", "Open message");
        openMessage.putValue("MnemonicKey", 79);
        openMessage.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
        openMessage.setEnabled(true);
        checkMailForAllAccounts = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AccountRecord accountRecord : AccountRecord.allActiveAccounts()) {
                    MessageReceiver.forAccount(accountRecord);
                }
            }
        };
        checkMailForAllAccounts.putValue("MnemonicKey", 65);
        checkMailForAllAccounts.putValue("Name", "Check new mail");
        checkMailForAllAccounts.putValue("ShortDescription", "Check new mail for all installed accounts");
        checkMailForAllAccounts.putValue("SmallIcon", Icons.getMail);
        checkMailForAccount = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryAccountTreeNode treeNode = TreePanel.getSelectedNode();
                if (treeNode == null) {
                    Actions.errorMessage("Please select an account");
                } else {
                    AccountRecord accountRecord = treeNode.getParentAccount();
                    System.out.println("Checking new mail for " + accountRecord);
                    MessageReceiver.forAccount(accountRecord);
                }
            }
        };
        checkMailForAccount.putValue("MnemonicKey", 72);
        checkMailForAccount.putValue("Name", "Check mail for one account");
        createNewAccount = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAccountDialog.createAccount();
            }
        };
        createNewAccount.putValue("Name", "New account");
        createNewAccount.putValue("ShortDescription", "Create new mail account");
        createNewAccount.putValue("MnemonicKey", 78);
        deleteAccount = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryAccountTreeNode treeNode = TreePanel.getSelectedNode();
                if (treeNode == null) {
                    Actions.errorMessage("Please select an account");
                } else if (treeNode instanceof AccountNode) {
                    AccountNode accountNode = (AccountNode)treeNode;
                    System.out.println("selected account: " + accountNode.toString());
                    int answer = JOptionPane.showConfirmDialog(MainWindow.getInstance(), "Are you sure you want to delete " + accountNode + " account?", "Account deletion confirmation", 0);
                    if (answer == 0) {
                        System.out.println("Now deleting " + accountNode);
                        DirectoryTreeModel.deleteAccount(accountNode);
                    }
                } else {
                    Actions.errorMessage("Please select an account");
                }
            }
        };
        deleteAccount.putValue("Name", "Delete account");
        saveAccountID = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryAccountTreeNode treeNode = TreePanel.getSelectedNode();
                if (treeNode == null) {
                    Actions.errorMessage("Please select an account");
                } else if (treeNode instanceof AccountNode) {
                    AccountNode accountNode = (AccountNode)treeNode;
                    System.out.println("selected account: " + accountNode.toString());
                    SecureID secureID = accountNode.getSecureID();
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    int returnVal = fc.showDialog(MainWindow.getInstance(), "Select directory to save ID");
                    if (returnVal == 0) {
                        File directoryToSaveTo = fc.getSelectedFile();
                        try {
                            secureID.saveToDirectory(directoryToSaveTo);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Actions.errorMessage("Please select an account");
                }
            }
        };
        saveAccountID.putValue("Name", "Save accounts ID");
        deleteAttachment = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.deleteAttachment();
            }
        };
        deleteAttachment.putValue("Name", "Delete Attachment");
        saveOneAttachment = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.saveOneAttachment();
            }
        };
        saveOneAttachment.putValue("Name", "Save Attachment");
        saveAllAttachments = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.saveAllAttachments();
            }
        };
        saveAllAttachments.putValue("Name", "Save All Attachments");
        launchDomainManager = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainManagerDialog.manageDomains();
            }
        };
        launchDomainManager.putValue("Name", "Domain Manager");
        Actions.setPermission((DirectoryAccountTreeNode)DirectoryTreeModel.getInstance().getRoot());
    }
}

