/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.app;

import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.DoubleField;
import com.jslope.persistence.fields.IDField;
import com.jslope.persistence.fields.IntField;
import com.jslope.persistence.fields.VarcharField;
import java.awt.Dimension;
import java.awt.Point;

public class Options
extends DBPersistentObject {
    public static final String SPLIT_PANE = "splitPane";
    public static final String HORIZ_SPLIT_PANE = "horizSplitPane";
    public static final String ATT_SPLIT_PANE = "attsplitpane";
    public static final String WINDOW_X = "windowX";
    public static final String WINDOW_Y = "windowY";
    public static final String WINDOW_WIDTH = "windowWidth";
    public static final String WINDOW_HEIGHT = "windowHeight";
    public static final String SELECTED_NODE = "selectedNode";
    public static final String COLUMN_WIDTHS = "colwidths";
    static Options ourInstance = null;

    @Override
    public void define() {
        this.addField(WINDOW_X, new DoubleField(70.0));
        this.addField(WINDOW_Y, new DoubleField(50.0));
        this.addField(WINDOW_WIDTH, new DoubleField(720.0));
        this.addField(WINDOW_HEIGHT, new DoubleField(420.0));
        this.addField(SPLIT_PANE, new IntField(188));
        this.addField(HORIZ_SPLIT_PANE, new IntField(79));
        this.addField(ATT_SPLIT_PANE, new IntField(289));
        this.addField(COLUMN_WIDTHS, new VarcharField(79));
        this.addField(SELECTED_NODE, new IDField());
    }

    public static Options getInstance() {
        if (ourInstance == null) {
            Options tempInstance = new Options();
            ObjectList result = tempInstance.loadObjects();
            if (result.hasNext()) {
                ourInstance = (Options)result.next();
                System.out.println("loaded options, options id = " + ourInstance.getID());
            } else {
                ourInstance = tempInstance;
                ourInstance.save();
                System.out.println("created options, options id = " + ourInstance.getID());
            }
        }
        return ourInstance;
    }

    public Point getWindowLocation() {
        return new Point((int)((DoubleField)this.getField(WINDOW_X)).getDoubleValue(), (int)((DoubleField)this.getField(WINDOW_Y)).getDoubleValue());
    }

    public Dimension getWindowSize() {
        return new Dimension((int)((DoubleField)this.getField(WINDOW_WIDTH)).getDoubleValue(), (int)((DoubleField)this.getField(WINDOW_HEIGHT)).getDoubleValue());
    }

    public void setWindowLocation(Point location) {
        this.set(WINDOW_X, "" + location.getX());
        this.set(WINDOW_Y, "" + location.getY());
    }

    public void setWindowSize(Dimension size) {
        this.set(WINDOW_WIDTH, "" + size.getWidth());
        this.set(WINDOW_HEIGHT, "" + size.getHeight());
    }

    public int getSplitPane() {
        return ((IntField)this.getField(SPLIT_PANE)).getIntValue();
    }

    public void setVerticalSplitPane(int newValue) {
        ((IntField)this.getField(SPLIT_PANE)).setIntValue(newValue);
    }

    public int getHorizontallSplit() {
        return ((IntField)this.getField(HORIZ_SPLIT_PANE)).getIntValue();
    }

    public int getAttachmentsSplit() {
        return ((IntField)this.getField(ATT_SPLIT_PANE)).getIntValue();
    }

    public void setHorisontalSplit(int newValue) {
        ((IntField)this.getField(HORIZ_SPLIT_PANE)).setIntValue(newValue);
    }

    public void setAttachmentSplit(int newValue) {
        ((IntField)this.getField(ATT_SPLIT_PANE)).setIntValue(newValue);
    }

    public void setSelectedNode(DirectoryAccountTreeNode node) {
        if (node == null) {
            this.set(SELECTED_NODE, "null_id");
        } else {
            this.set(SELECTED_NODE, node.getRecordID());
        }
    }

    public String getSelectedNodeID() {
        String nodeID = this.get(SELECTED_NODE);
        if (nodeID.equals("null_id")) {
            return null;
        }
        return nodeID;
    }

    public void setColumnWidths(String columnWidths) {
        this.set(COLUMN_WIDTHS, columnWidths);
    }

    public String getColumnWidths() {
        return this.get(COLUMN_WIDTHS);
    }
}

