/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.ConfigureServerDialog;
import com.jslope.client.domainmanager.CreateIDPermissionDialog;
import com.jslope.client.domainmanager.CreateSubdomainDialog;
import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.domainmanager.InstallDomainDialog;
import com.jslope.client.domainmanager.UpdateDomainServerDialog;
import com.jslope.client.domainmanager.elements.ShowSignedIDs;
import com.jslope.client.ui.MainWindow;
import com.jslope.framework.DomainManager;
import com.jslope.security.Domain;
import com.jslope.security.PublicID;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;

public class DomainActions {
    public static AbstractAction[] allActions;
    public static AbstractAction importDomain;
    public static AbstractAction registerDomain;
    public static AbstractAction createSubdomain;
    public static AbstractAction signSubdomain;
    public static AbstractAction createMailAccount;
    private static AbstractAction installDomainOnServer;
    private static AbstractAction updateServerDNS;
    private static AbstractAction signMailAccountsOnServer;
    private static AbstractAction configureNewServer;

    private static void initActions() {
        importDomain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        importDomain.putValue("Name", "Import Domain");
        registerDomain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        registerDomain.putValue("Name", "Register New Domain");
        createSubdomain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    CreateSubdomainDialog.createSubdomain(DomainManagerDialog.getSelectedDomain());
                }
            }
        };
        createSubdomain.putValue("Name", "Create Subdomain");
        signSubdomain = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        signSubdomain.putValue("Name", "Sign Subdomain");
        createMailAccount = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    CreateIDPermissionDialog.createID(DomainManagerDialog.getSelectedDomain());
                }
            }
        };
        createMailAccount.putValue("Name", "Create Mail Account");
        signMailAccountsOnServer = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    Domain domain = DomainManagerDialog.getSelectedDomain();
                    Set<PublicID> signedIDs = DomainManager.signIDsOnServer(domain, MainWindow.getNewSystemErrorHandler());
                    ShowSignedIDs.showIDs(signedIDs);
                }
            }
        };
        signMailAccountsOnServer.putValue("Name", "Sign ID on server");
        installDomainOnServer = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    InstallDomainDialog.installDomain(DomainManagerDialog.getSelectedDomain());
                }
            }
        };
        installDomainOnServer.putValue("Name", "Install domain on server");
        updateServerDNS = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    UpdateDomainServerDialog.updateDomain(DomainManagerDialog.getSelectedDomain());
                }
            }
        };
        updateServerDNS.putValue("Name", "Update server address");
        configureNewServer = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DomainManagerDialog.verifyIfDomainIsSelected()) {
                    ConfigureServerDialog.installDomain(DomainManagerDialog.getSelectedDomain());
                }
            }
        };
        configureNewServer.putValue("Name", "Configure new server");
        allActions = new AbstractAction[]{importDomain, registerDomain, createSubdomain, signSubdomain, createMailAccount, signMailAccountsOnServer, installDomainOnServer, updateServerDNS, configureNewServer};
    }

    static {
        DomainActions.initActions();
    }
}

