/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainFileFilter;
import com.jslope.io.Config;
import com.jslope.security.Domain;
import com.jslope.security.impl.JSlopeDomain;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DomainList {
    private static Map<String, Domain> domainList = new HashMap<String, Domain>();
    private static volatile boolean isInitializing = true;

    public static void renew() {
        domainList.clear();
        try {
            for (File domainFile : DomainList.getDomainFiles()) {
                System.out.println("Adding domain file " + domainFile.getName());
                Domain domain = JSlopeDomain.loadNewFromFile(domainFile);
                domainList.put(domain.getName(), domain);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File[] getDomainFiles() {
        String domainDir = Config.getDomainsDirectory();
        System.out.println("Domain dir: " + domainDir);
        File domainDirectory = new File(domainDir);
        if (!domainDirectory.exists()) {
            domainDirectory.mkdirs();
        }
        return domainDirectory.listFiles(new DomainFileFilter());
    }

    public static Iterable<? extends String> getDomainNames() {
        return domainList.keySet();
    }

    public static Domain getDomain(String domainName) {
        while (isInitializing) {
        }
        return domainList.get(domainName);
    }

    static {
        isInitializing = true;
        DomainList.renew();
        isInitializing = false;
    }
}

