/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainActions;
import com.jslope.client.domainmanager.DomainList;
import com.jslope.client.ui.MainWindow;
import com.jslope.security.Domain;
import java.awt.GridLayout;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DomainManagerDialog
extends JDialog {
    private JList domainList;
    private DefaultListModel listModel;
    private static DomainManagerDialog ourInstance = null;

    private DomainManagerDialog() {
        super(MainWindow.getInstance(), "Domain Manager", false);
        JPanel pane = new JPanel();
        this.listModel = new DefaultListModel();
        this.loadDomainsToListModel(this.listModel);
        this.domainList = new JList(this.listModel);
        JScrollPane scrollListPane = new JScrollPane(this.domainList);
        pane.add(scrollListPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridLayout(0, 1));
        for (AbstractAction action : DomainActions.allActions) {
            JButton button = new JButton(action);
            buttonPane.add(button);
        }
        pane.add("East", buttonPane);
        this.setContentPane(pane);
        this.pack();
    }

    private void loadDomainsToListModel(DefaultListModel listModel) {
        for (String string : DomainList.getDomainNames()) {
            listModel.addElement(string);
        }
    }

    public static DomainManagerDialog getInstance() {
        if (ourInstance == null) {
            ourInstance = new DomainManagerDialog();
        }
        return ourInstance;
    }

    public static void manageDomains() {
        DomainList.renew();
        DomainManagerDialog.getInstance().setVisible(true);
    }

    public static boolean verifyIfDomainIsSelected() {
        if (DomainManagerDialog.getInstance().isDomainSelected()) {
            return true;
        }
        JOptionPane.showMessageDialog(DomainManagerDialog.getInstance(), "Please select a domain", "Domain is not selcted", 0);
        return false;
    }

    private boolean isDomainSelected() {
        return !this.domainList.isSelectionEmpty();
    }

    public static Domain getSelectedDomain() {
        String domainName = DomainManagerDialog.getInstance().getSelectedDomainName();
        return DomainList.getDomain(domainName);
    }

    private String getSelectedDomainName() {
        return (String)this.domainList.getSelectedValue();
    }

    public static void renewDomains() {
        DomainManagerDialog.getInstance().renewAllDomains();
    }

    private void renewAllDomains() {
        DomainList.renew();
        this.listModel.clear();
        this.loadDomainsToListModel(this.listModel);
    }
}

