/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.io.serverlistener;

import com.jslope.client.io.serverlistener.ClientServerListenerThread;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.logger.Log;
import com.jslope.security.SecureID;
import java.util.concurrent.ConcurrentHashMap;

public class ClientServerListener {
    private static ConcurrentHashMap<String, ClientServerListenerThread> serverThreads = new ConcurrentHashMap();

    public static void addListener(SecureID unsignedID) {
        String idName = unsignedID.getName();
        Log.debug("Adding client-server listener for id: " + idName);
        if (!serverThreads.containsKey(idName)) {
            Log.debug("there is no listener for id: " + idName + " so we're creating one");
            ClientServerListener.listenTo(unsignedID);
        } else {
            Log.debug("there is already listener for id: " + idName + " so we're doing nothing");
        }
    }

    public static void initSeverListener() {
        System.out.println("Initializing Server Listeners");
        for (SecureID secureID : ClientServerListener.getServersToListenTo()) {
            ClientServerListener.listenTo(secureID);
        }
    }

    private static void listenTo(SecureID unsignedID) {
        ClientServerListenerThread thread = new ClientServerListenerThread(unsignedID);
        Log.debug("Create Account 5: creating listening thread");
        serverThreads.put(unsignedID.getName(), thread);
        new Thread(thread).start();
    }

    private static Iterable<? extends SecureID> getServersToListenTo() {
        return AccountRecord.getServersWithUnsignedIDs();
    }

    public static boolean areThereMoreWaitingForID(String idName) {
        if (serverThreads.containsKey(idName)) {
            if (AccountRecord.isIDSigned(idName)) {
                serverThreads.remove(idName);
            } else {
                return true;
            }
        }
        return false;
    }
}

