/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.io.serverlistener;

import com.jslope.client.io.serverlistener.ServerListenerThread;
import com.jslope.client.ui.persistent.WaitingUnsignedID;
import com.jslope.logger.Log;
import com.jslope.security.impl.IDFactory;
import java.util.concurrent.ConcurrentHashMap;

public class ServerListener {
    private static ConcurrentHashMap serverThreads = new ConcurrentHashMap();

    public static void addListener(String idName) {
        String domainName = IDFactory.getDomainName(idName);
        if (!serverThreads.containsKey(domainName)) {
            Log.debug("Create ID 3.1: now will start listening for domain" + domainName + " because of creation of id: " + idName);
            ServerListener.listenTo(domainName);
        } else {
            Log.debug("Create ID 3.2: will NOT start listening for domain" + domainName + " because of creation of id: " + idName + " because we're already listening ");
        }
        WaitingUnsignedID.addUnsignedIDToWaitFor(idName);
        Log.debug("Create ID 4: added unsigned ID to the list (to wait for)" + idName);
    }

    public static void initSeverListener() {
        System.out.println("Initializing Server Listeners");
        for (String string : ServerListener.getServersToListenTo()) {
            ServerListener.listenTo(string);
        }
    }

    private static void listenTo(String serverName) {
        ServerListenerThread thread = new ServerListenerThread(serverName);
        serverThreads.put(serverName, thread);
        new Thread(thread).start();
    }

    private static Iterable<? extends String> getServersToListenTo() {
        return WaitingUnsignedID.getServers();
    }

    public static boolean areThereMoreWaitingForDomain(String domainName) {
        if (serverThreads.containsKey(domainName)) {
            if (WaitingUnsignedID.areThereMoreWaitingForDomain(domainName)) {
                return true;
            }
            serverThreads.remove(domainName);
        }
        return false;
    }
}

