/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.tree;

import com.jslope.client.app.Options;
import com.jslope.client.tree.AccountTreeCellRenerer;
import com.jslope.client.ui.controler.NodeSelectionChangeListener;
import com.jslope.client.ui.model.AbstractDirectoryNode;
import com.jslope.client.ui.model.AccountNode;
import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.model.DirectoryTreeModel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreePanel {
    private static JTree tree;

    public TreePanel() {
        tree = new JTree(DirectoryTreeModel.getInstance());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(new NodeSelectionChangeListener(tree));
        tree.setCellRenderer(new AccountTreeCellRenerer());
        String selectedNodeID = Options.getInstance().getSelectedNodeID();
        if (selectedNodeID != null) {
            AbstractDirectoryNode node = null;
            if (AccountNode.hasNodeWithID(selectedNodeID)) {
                node = AccountNode.getNode(selectedNodeID);
            } else if (Directory.hasNodeWithID(selectedNodeID)) {
                node = Directory.getNode(selectedNodeID);
            }
            if (node != null) {
                this.selectNode(node);
            }
        }
    }

    public void selectNode(AbstractDirectoryNode node) {
        TreePath path = node.getPathToRoot();
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public static void initialize() {
        new TreePanel();
    }

    public static JTree getTree() {
        return tree;
    }

    public static DirectoryAccountTreeNode getSelectedNode() {
        TreePath currentSelection = tree.getSelectionPath();
        if (currentSelection == null) {
            return null;
        }
        return (DirectoryAccountTreeNode)currentSelection.getLastPathComponent();
    }

    public static boolean isSelected(DirectoryAccountTreeNode nodeToBeCompared) {
        DirectoryAccountTreeNode selectedNode = TreePanel.getSelectedNode();
        return selectedNode == nodeToBeCompared;
    }
}

