/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.dialog;

import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.DialogElement;
import com.jslope.client.ui.utils.SpringUtilities;
import com.jslope.security.crypto.impl.CryptogException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class AbstractOkCancelDialog
extends JDialog {
    protected JPanel pane = new JPanel(new SpringLayout());
    private int numberOfAddedComponents = 0;

    public AbstractOkCancelDialog(MainWindow parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    public AbstractOkCancelDialog(MainWindow parent, String title) {
        this(parent, title, false);
    }

    protected void finishDialog() {
        SpringUtilities.makeCompactGrid(this.pane, this.numberOfAddedComponents, 2, 5, 5, 5, 5);
        JButton ok = new JButton("Ok");
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (AbstractOkCancelDialog.this.validateAction()) {
                        AbstractOkCancelDialog.this.setVisible(false);
                    }
                }
                catch (CryptogException e1) {
                    e1.printStackTrace();
                    throw new RuntimeException(e1);
                }
            }
        });
        JButton cancel = new JButton("cancel");
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractOkCancelDialog.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(ok);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(cancel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.pane, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.setContentPane(mainPanel);
        this.pack();
    }

    protected abstract boolean validateAction() throws CryptogException;

    protected void addComponent(JComponent component) {
        this.addComponent("", component);
    }

    public void addComponent(String s, JComponent component) {
        JLabel l = new JLabel(s, 11);
        this.pane.add(l);
        l.setLabelFor(component);
        this.pane.add(component);
        ++this.numberOfAddedComponents;
    }

    protected void addComponent(DialogElement idDialog) {
        idDialog.addTo(this);
    }
}

