/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.persistent;

import com.jslope.client.app.Consts;
import com.jslope.client.ui.persistent.AttachmentRef;
import com.jslope.client.ui.persistent.AttachmentReference;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.io.protocol.messages.AttachmentObject;
import com.jslope.io.protocol.messages.FileAttachmentObject;
import com.jslope.io.utils.IOUtils;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.BlobField;
import com.jslope.persistence.fields.IDField;
import com.jslope.persistence.fields.VarcharField;
import com.jslope.persistence.sql.Condition;
import com.jslope.persistence.sql.ResultIterator;
import com.jslope.persistence.sql.ResultRow;
import com.jslope.persistence.sql.SqlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AttachmentRecord
extends DBPersistentObject {
    private static final String MESSAGE_ID = "parentmessage";
    private static final String FILE_NAME = "fileName";
    private static final String CONTENT = "content";
    private static final AttachmentRecord workObject = new AttachmentRecord();
    private static final String[] refFields = new String[]{"OBJECT_ID", "fileName"};
    private static final String[] sortFields = new String[]{"fileName"};

    @Override
    public void define() {
        this.addField(MESSAGE_ID, new IDField());
        this.addField(FILE_NAME, new VarcharField(Consts.maxFileName));
        this.addField(CONTENT, new BlobField());
    }

    public static void addAttachments(MessageRecord parentMessage, File[] files) {
        for (File file : files) {
            if (!file.isFile() || file.isDirectory()) continue;
            AttachmentRecord newAttachment = new AttachmentRecord();
            newAttachment.setMessage(parentMessage);
            newAttachment.setFile(file);
            newAttachment.save();
        }
    }

    private void setFile(File file) {
        this.setFileName(file.getName());
        byte[] fileContent = IOUtils.loadFile(file);
        this.setContent(fileContent);
    }

    public void setContent(byte[] fileContent) {
        ((BlobField)this.getField(CONTENT)).setData(fileContent);
    }

    private byte[] getContent() {
        return ((BlobField)this.getField(CONTENT)).getData();
    }

    private void setFileName(String name) {
        this.set(FILE_NAME, name);
    }

    private String getFileName() {
        return this.get(FILE_NAME);
    }

    public void setMessage(MessageRecord parentMessage) {
        this.setMessage(parentMessage.getID());
    }

    private void setMessage(String messageID) {
        this.set(MESSAGE_ID, messageID);
    }

    public static List<AttachmentRef> getAttachmentRefs(MessageRecord parentMessage) {
        return AttachmentRecord.getAttachmentRefs(parentMessage.getID());
    }

    public static List<AttachmentRef> getAttachmentRefs(String messageID) {
        ResultIterator resultIterator = SqlUtil.find(workObject.getTableName(), refFields, Condition.var(MESSAGE_ID).Equal(messageID), sortFields);
        ArrayList<AttachmentRef> retVal = new ArrayList<AttachmentRef>();
        while (resultIterator.hasNext()) {
            ResultRow resultRow = resultIterator.next();
            String id = resultRow.getString("OBJECT_ID");
            String name = resultRow.getString(FILE_NAME);
            retVal.add(new AttachmentReference(id, name));
        }
        return retVal;
    }

    public static List<AttachmentObject> getAttachments(String messageID) {
        LinkedList<AttachmentObject> retVal = new LinkedList<AttachmentObject>();
        ObjectList objList = workObject.loadObjects(Condition.var(MESSAGE_ID).Equal(messageID));
        while (objList.hasNext()) {
            AttachmentRecord obj = (AttachmentRecord)objList.next();
            retVal.add(obj.getAttachmentObject());
        }
        return retVal;
    }

    public static List<AttachmentRecord> getAttachmentRecords(String messageID) {
        LinkedList<AttachmentRecord> retVal = new LinkedList<AttachmentRecord>();
        ObjectList objList = workObject.loadObjects(Condition.var(MESSAGE_ID).Equal(messageID));
        while (objList.hasNext()) {
            AttachmentRecord obj = (AttachmentRecord)objList.next();
            retVal.add(obj);
        }
        return retVal;
    }

    private AttachmentObject getAttachmentObject() {
        FileAttachmentObject obj = new FileAttachmentObject();
        obj.setFile(this.getFileName(), this.getContent());
        return obj;
    }

    public void setObject(AttachmentObject attchObj) {
        this.setContent(attchObj.getContent());
        this.setFileName(attchObj.getName());
    }

    public static AttachmentObject getObjectWithID(String id) {
        AttachmentRecord record = AttachmentRecord.getRecord(id);
        return record.getAttachmentObject();
    }

    private static AttachmentRecord getRecord(String id) {
        return (AttachmentRecord)DBPersistentObject.loadObject(id);
    }
}

