/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.persistent;

import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.model.DirectoryTreeModel;
import com.jslope.client.ui.model.PersistentAccount;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.client.ui.persistent.PersistentDirectory;
import com.jslope.client.ui.persistent.PersistentTreeElement;
import com.jslope.logger.Log;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.LoadException;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.IDField;
import com.jslope.persistence.fields.IntField;
import com.jslope.persistence.fields.VarcharField;
import com.jslope.persistence.sql.Condition;
import java.util.LinkedList;
import java.util.List;

public class DirectoryRecord
extends DBPersistentObject
implements PersistentTreeElement,
PersistentDirectory {
    private static final String DIRECTORY_NAME = "dirname";
    private static final String PARENT = "parent";
    private static final String SORT_INDEX = "sortindex";
    private static final String SELECTED_MESSAGE = "selectmsg";
    static final DirectoryRecord workObject = new DirectoryRecord();

    @Override
    public void define() {
        this.addField(DIRECTORY_NAME, new VarcharField(355));
        this.addField(PARENT, new IDField());
        this.addField(SORT_INDEX, new IntField());
        this.addField(SELECTED_MESSAGE, new IDField());
    }

    public static List<DirectoryRecord> getChildsOf(String id) {
        LinkedList<DirectoryRecord> retVal = new LinkedList<DirectoryRecord>();
        ObjectList objectList = workObject.loadObjects(Condition.var(PARENT).Equal(id), new String[]{SORT_INDEX});
        while (objectList.hasNext()) {
            retVal.add((DirectoryRecord)objectList.next());
        }
        return retVal;
    }

    private static DirectoryRecord loadDirectoryByIDAndName(String id, String dirName) {
        return (DirectoryRecord)workObject.loadOneObject(Condition.var(PARENT).Equal(id).AND(DIRECTORY_NAME).Equal(dirName));
    }

    public static DirectoryRecord getOutboxFor(String id) {
        return DirectoryRecord.loadDirectoryByIDAndName(id, "Outbox");
    }

    public static PersistentDirectory getDraftsFor(String id) {
        return DirectoryRecord.loadDirectoryByIDAndName(id, "Drafts");
    }

    public static DirectoryRecord getSentFor(String id) {
        return DirectoryRecord.loadDirectoryByIDAndName(id, "Sent");
    }

    public static DirectoryRecord getInboxtFor(String id) {
        return DirectoryRecord.loadDirectoryByIDAndName(id, "Inbox");
    }

    public static PersistentDirectory getTrashFor(String id) {
        return DirectoryRecord.loadDirectoryByIDAndName(id, "Trash");
    }

    public static void deleteAllChildsOf(String id) {
        workObject.deleteObjects(Condition.var(PARENT).Equal(id));
    }

    public void setName(String name) {
        this.set(DIRECTORY_NAME, name);
    }

    public void setParent(String id, int index) {
        this.set(PARENT, id);
        this.setSortIndex(index);
    }

    private void setSortIndex(int index) {
        ((IntField)this.getField(SORT_INDEX)).setIntValue(index);
    }

    public String toString() {
        return this.getName();
    }

    private String getName() {
        return this.get(DIRECTORY_NAME);
    }

    public int getNumberOfMessages() {
        return (int)MessageRecord.getNumberOfMessagesForDirectory(this);
    }

    @Override
    public void updateUI() {
        Directory directory = Directory.getNode(this.getID());
        directory.updateNumberOfMessages();
        if (directory.isSelected()) {
            directory.updateEditor();
        }
        DirectoryTreeModel.updateNode(directory);
    }

    @Override
    public PersistentAccount getAccount() {
        PersistentTreeElement parent = this.getParent();
        if (parent instanceof DirectoryRecord) {
            return ((DirectoryRecord)parent).getAccount();
        }
        return (PersistentAccount)((Object)parent);
    }

    @Override
    public boolean isTrashDirecotry() {
        return this.getName().equals("Trash");
    }

    @Override
    public boolean isDraftsDirecotry() {
        return this.getName().equals("Drafts");
    }

    @Override
    public boolean isOutboxDirectory() {
        return this.getName().equals("Outbox");
    }

    public boolean isInboxDirectory() {
        return this.getName().equals("Inbox");
    }

    public boolean isSentDirectory() {
        return this.getName().equals("Sent");
    }

    private PersistentTreeElement getParent() {
        return (PersistentTreeElement)((Object)DirectoryRecord.loadObject(this.getParentID()));
    }

    private String getParentID() {
        return this.get(PARENT);
    }

    public void setSelectedMessage(MessageRecord selectedMessage) {
        if (selectedMessage == null) {
            this.set(SELECTED_MESSAGE, "null_id");
        } else {
            this.set(SELECTED_MESSAGE, selectedMessage.getID());
        }
    }

    public MessageRecord getSelectedMessage() {
        String messageID = this.get(SELECTED_MESSAGE);
        if (messageID.equals("null_id")) {
            return null;
        }
        try {
            return MessageRecord.loadMessage(messageID);
        }
        catch (LoadException e) {
            Log.error("Message with messageID = " + messageID + " was not found", e);
            return null;
        }
    }
}

