/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.persistent;

import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.AttachmentRecord;
import com.jslope.client.ui.persistent.AttachmentRef;
import com.jslope.client.ui.persistent.DirectoryRecord;
import com.jslope.client.ui.persistent.PersistentDirectory;
import com.jslope.client.ui.utils.SwingQueue;
import com.jslope.framework.DNS;
import com.jslope.io.protocol.messages.AttachmentObject;
import com.jslope.io.protocol.messages.DefaultOpenMessage;
import com.jslope.io.protocol.messages.OpenMessage;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.IDField;
import com.jslope.persistence.fields.TextField;
import com.jslope.persistence.fields.TimestampField;
import com.jslope.persistence.fields.VarcharField;
import com.jslope.persistence.sql.Condition;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class MessageRecord
extends DBPersistentObject {
    private static final String FROM = "fromid";
    private static final String TO = "toid";
    private static final String SUBJECT = "subject";
    private static final String MESSAGE_TEXT = "messagetext";
    private static final String PARENT = "parent";
    private static final String RECEIVED_DATE = "recdate";
    static final MessageRecord workObject = new MessageRecord();
    private static SimpleDateFormat formatter = new SimpleDateFormat("dd MMMM yyyy, HH:mm");

    @Override
    public void define() {
        this.addField(FROM, new VarcharField(355));
        this.addField(TO, new VarcharField(355));
        this.addField(SUBJECT, new VarcharField(256));
        this.addField(MESSAGE_TEXT, new TextField());
        this.addField(PARENT, new IDField());
        this.addField(RECEIVED_DATE, new TimestampField());
    }

    public void setSubject(String subject) {
        this.set(SUBJECT, subject);
    }

    public void setFrom(String fromAsText) {
        this.set(FROM, fromAsText);
    }

    public void setTo(String to) {
        this.set(TO, to);
    }

    public void setText(String messageText) {
        this.set(MESSAGE_TEXT, messageText);
    }

    public String getText() {
        return this.get(MESSAGE_TEXT);
    }

    public void setParent(PersistentDirectory parentDir) {
        this.set(PARENT, parentDir.getID());
    }

    public String getParentID() {
        return this.get(PARENT);
    }

    public String getFrom() {
        return this.get(FROM);
    }

    public String getTo() {
        return this.get(TO);
    }

    public String getSubject() {
        return this.get(SUBJECT);
    }

    public static List<MessageRecord> getMessagesForDirectory(Directory directory) {
        ArrayList<MessageRecord> retList = new ArrayList<MessageRecord>();
        ObjectList objectList = workObject.loadObjects(Condition.var(PARENT).Equal(directory.getRecord().getID()), new String[]{"recdate DESC"});
        while (objectList.hasNext()) {
            retList.add((MessageRecord)objectList.next());
        }
        return retList;
    }

    public String getMessageText() {
        return this.get(MESSAGE_TEXT);
    }

    public SecureID getFromID() {
        return AccountRecord.getSecureID(this.getFrom());
    }

    public OpenMessage createOpenMessage() {
        PublicID destination = DNS.getID(this.get(TO), MainWindow.getNewSystemErrorHandler());
        SecureID fromID = this.getFromID();
        List<AttachmentObject> attachments = this.getAttachments();
        DefaultOpenMessage retVal = new DefaultOpenMessage(fromID.getPublicPart(), destination, this.getSubject(), this.getMessageText());
        retVal.setAttachments(attachments);
        return retVal;
    }

    public List<AttachmentObject> getAttachments() {
        return AttachmentRecord.getAttachments(this.getID());
    }

    public List<AttachmentRecord> getAttachmentRecords() {
        return AttachmentRecord.getAttachmentRecords(this.getID());
    }

    public List<AttachmentRef> getAttachmentsInfo() {
        return AttachmentRecord.getAttachmentRefs(this);
    }

    public void moveToSendFolder() {
        AccountRecord account = AccountRecord.getAccountRecord(this.getFrom());
        this.setParent(account.getSentDirectory());
        this.save();
        final PersistentDirectory directory = this.getParent();
        SwingQueue.invokeAndWaitNoEx(new Runnable(){

            @Override
            public void run() {
                directory.updateUI();
            }
        });
    }

    public PersistentDirectory getParent() {
        return (DirectoryRecord)MessageRecord.loadObject(this.getParentID());
    }

    public void setOpenMessage(OpenMessage message) {
        this.setFrom(message.getFromID().getName());
        this.setTo(message.getDestinationID().getName());
        this.setText(message.getText());
        this.setSubject(message.getSubject());
        for (AttachmentObject attchObj : message.getAttachments()) {
            AttachmentRecord record = new AttachmentRecord();
            record.setMessage(this);
            record.setObject(attchObj);
            record.save();
        }
    }

    public static long getNumberOfMessagesForDirectory(DirectoryRecord directoryRecord) {
        return workObject.count(Condition.var(PARENT).Equal(directoryRecord.getID()));
    }

    public static MessageRecord loadMessage(String messageID) {
        return (MessageRecord)MessageRecord.loadObject(messageID);
    }

    public String getQuotedMessageText() {
        String text = this.getMessageText();
        String quotedText = "\n\n";
        for (String line : text.split("\n")) {
            quotedText = quotedText + "\n> " + line;
        }
        return quotedText;
    }

    public String getReceivedDate() {
        return formatter.format(((TimestampField)this.getField(RECEIVED_DATE)).getDate());
    }

    @Override
    public void deleteObject() {
        for (AttachmentRecord attachment : this.getAttachmentRecords()) {
            attachment.deleteObject();
        }
        super.deleteObject();
    }
}

