/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.view.attachments;

import com.jslope.client.app.Actions;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.persistent.AttachmentRef;
import com.jslope.client.ui.view.FileAttachmentsModel;
import com.jslope.client.ui.view.attachments.DirectoryViewAttachmentsPopup;
import com.jslope.client.ui.view.attachments.MessageEditorAttachmentsPopup;
import com.jslope.io.protocol.messages.AttachmentObject;
import com.jslope.io.utils.IOUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public class AttachmentList {
    boolean fromMessageEditor;
    FileAttachmentsModel fileAttachmentsModel;
    JList attachmentList;
    JPanel attachments;
    private static AttachmentList currentList = null;

    public AttachmentList(boolean isFromMessageEditor) {
        this.fromMessageEditor = isFromMessageEditor;
    }

    public Component getRepresentation() {
        this.fileAttachmentsModel = new FileAttachmentsModel();
        this.attachmentList = new JList();
        this.attachmentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AttachmentList.this.checkPopupForAttachments(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AttachmentList.this.checkPopupForAttachments(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AttachmentList.this.checkPopupForAttachments(e);
            }
        });
        this.attachmentList.setModel(this.fileAttachmentsModel);
        this.attachmentList.setSelectionMode(0);
        this.attachments = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane(this.attachmentList);
        jScrollPane2.setPreferredSize(new Dimension(1000, 1000));
        JLabel jLabel1 = new JLabel("Attachments");
        GroupLayout attachementPaneLayout = new GroupLayout((Container)this.attachments);
        this.attachments.setLayout((LayoutManager)attachementPaneLayout);
        attachementPaneLayout.setHorizontalGroup((GroupLayout.Group)attachementPaneLayout.createParallelGroup(1).add((GroupLayout.Group)attachementPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)attachementPaneLayout.createParallelGroup(1).add((Component)jLabel1).add(2, (Component)jScrollPane2, -1, 96, Short.MAX_VALUE)).addContainerGap()));
        attachementPaneLayout.setVerticalGroup((GroupLayout.Group)attachementPaneLayout.createParallelGroup(1).add((GroupLayout.Group)attachementPaneLayout.createSequentialGroup().add((Component)jLabel1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)jScrollPane2, 0, -1, Short.MAX_VALUE)));
        return this.attachments;
    }

    private void checkPopupForAttachments(MouseEvent e) {
        if (e.isPopupTrigger()) {
            currentList = this;
            System.out.println("Popup trigger + slected index = " + this.attachmentList.getSelectedIndex());
            Actions.saveOneAttachment.setEnabled(this.isOneSelected());
            if (this.fromMessageEditor) {
                MessageEditorAttachmentsPopup.show(this.attachmentList, e.getPoint());
            } else {
                DirectoryViewAttachmentsPopup.show(this.attachmentList, e.getPoint());
            }
        }
    }

    private boolean isOneSelected() {
        int index = this.attachmentList.getSelectedIndex();
        return index != -1 && index < this.fileAttachmentsModel.getSize();
    }

    public AttachmentRef getSelectedAttachmentRef() {
        int index = this.attachmentList.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (AttachmentRef)this.fileAttachmentsModel.getElementAt(index);
    }

    public AttachmentObject getSelectedAttachment() {
        AttachmentRef ref = this.getSelectedAttachmentRef();
        if (ref != null) {
            return ref.getAttachmentObject();
        }
        return null;
    }

    public void saveSelectedAttachment() {
        AttachmentObject attachment = this.getSelectedAttachment();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showDialog(MainWindow.getInstance(), "Select directory to save attachment");
        if (returnVal == 0) {
            File directoryToSaveTo = fc.getSelectedFile();
            System.out.println("Is directory" + directoryToSaveTo.isDirectory());
            System.out.println("dir: " + directoryToSaveTo);
            AttachmentList.saveOneAttachment(directoryToSaveTo, attachment);
        }
    }

    public static void saveOneAttachment(File directoryToSaveTo, AttachmentObject attachment) {
        File file = new File(directoryToSaveTo, attachment.getName());
        if (file.exists()) {
            int answer = JOptionPane.showConfirmDialog(MainWindow.getInstance(), "File " + attachment.getName() + " already exists there, otherwrite?", "Overwrite?", 0);
            if (answer == 0) {
                file.delete();
            } else {
                return;
            }
        }
        IOUtils.saveFile(file, attachment.getContent());
    }

    public void saveAllAttachments() {
        List<AttachmentRef> list = this.fileAttachmentsModel.getAllFiles();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showDialog(MainWindow.getInstance(), "Select directory to save attachment");
        if (returnVal == 0) {
            File directoryToSaveTo = fc.getSelectedFile();
            for (AttachmentRef ref : list) {
                AttachmentObject attObj = ref.getAttachmentObject();
                AttachmentList.saveOneAttachment(directoryToSaveTo, attObj);
            }
        }
    }

    public void setFiles(List<AttachmentRef> attachments) {
        this.fileAttachmentsModel.setFiles(attachments);
    }

    public static void saveOneSelectedAttachment() {
        if (currentList != null) {
            currentList.saveSelectedAttachment();
        }
    }

    public static void saveAllAttachmentsForCurrentList() {
        if (currentList != null) {
            currentList.saveAllAttachments();
        }
    }

    public boolean hasAttachments() {
        return this.fileAttachmentsModel.hasAttachments();
    }

    public static void deleteAttachment() {
        if (currentList != null) {
            currentList.deleteSelectedAttachment();
        }
    }

    private void deleteSelectedAttachment() {
        AttachmentRef ref = this.getSelectedAttachmentRef();
        if (ref != null) {
            int index = this.attachmentList.getSelectedIndex();
            this.fileAttachmentsModel.delete(index);
            ref.deleteAttachment();
        }
    }
}

