/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.errorhandling.impl;

import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.errorhandling.ProtocolError;
import com.jslope.io.protocol.errorhandling.impl.ErrorException;
import com.jslope.io.protocol.errorhandling.impl.TextError;
import com.jslope.io.protocol.errorhandling.impl.TextException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractErrorHandler
implements ErrorHandler {
    List<ProtocolError> errors = new ArrayList<ProtocolError>();

    @Override
    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    @Override
    public void addAndThrow(String shortDescription, String longDescription) {
        this.addError(shortDescription, longDescription);
        throw new RuntimeException(longDescription);
    }

    @Override
    public void addError(Exception e) {
        this.errors.add(new ErrorException(e));
    }

    @Override
    public void addError(String shortDescription, String longDescription, Exception e) {
        this.errors.add(new TextException(shortDescription, longDescription, e));
    }

    @Override
    public void addError(String shortDescription, String longDescription) {
        this.errors.add(new TextError(shortDescription, longDescription));
    }

    @Override
    public String getErrorsAsString() {
        StringBuffer b = new StringBuffer();
        for (ProtocolError err : this.errors) {
            b.append(err.toString());
        }
        return b.toString();
    }
}

