/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientHandler;
import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerEvent;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.PublicDomain;
import java.io.IOException;

public class ListenToServerAction
implements ProtocolAction {
    private static final byte WAITING_FOR_MORE_ACTIONS = 45;
    private static final byte END = 19;

    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        PublicDomain publicDomain = parentProtocol.getConnectedDomain();
        while (tr.readByte() == 45) {
            Log.debug("Waiting for server event in ListenToServerAction for domain: " + publicDomain.getName());
            ServerEvent event = serverHandler.getNextEventFor(publicDomain);
            event.writeServerEvent(tr);
            Log.debug("Server event sent for domain: " + publicDomain.getName());
        }
        Log.debug("Exiting ListenToServerAction for domain: " + publicDomain.getName());
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        String domainName = (String)parentProtocol.getValue(ProtocolConstants.DOMAIN_NAME);
        ClientHandler clientHandler = (ClientHandler)parentProtocol.getValue(ProtocolConstants.CLIENT_HANDLER);
        do {
            Log.debug("Now will listen to server for domain: " + domainName);
            tr.writeByte((byte)45);
            ServerEvent event = ServerEvent.readNewEvent(tr);
            Log.debug("Server event received for domain: " + domainName);
            clientHandler.processListenToServerEvent(domainName, event);
        } while (clientHandler.areThereMoreActionsToWaitFrom(domainName));
        Log.debug("Exiting ListenToServerAction for domain: " + domainName);
        tr.writeByte((byte)19);
    }
}

