/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerMailMessage;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.messages.MailMessage;
import com.jslope.io.protocol.messages.MessageFactory;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReceiveMessagesAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        PublicID verifiedPublicID = (PublicID)parentProtocol.getValue(ProtocolConstants.PUBLIC_ID);
        List<ServerMailMessage> messages = serverHandler.getMessagesFor(verifiedPublicID);
        System.out.println("Now will send " + messages.size() + " msgs to client ");
        tr.writeInt(messages.size());
        for (ServerMailMessage mailMessage : messages) {
            System.out.println("Preparing to send  message to: " + mailMessage.getMessage().getDestinationID());
            mailMessage.getMessage().serialize(tr);
            if (tr.readByte() != 1) continue;
            mailMessage.markAsSent();
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        int numberOfMessages = tr.readInt();
        ArrayList<MailMessage> messages = new ArrayList<MailMessage>();
        for (int i = 0; i < numberOfMessages; ++i) {
            messages.add(MessageFactory.deserializeMailMessage(tr));
            tr.writeByte((byte)1);
        }
        parentProtocol.setValue(ProtocolConstants.MAIL_MESSAGES, messages);
    }
}

