/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.impl.AbstractProtocol;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import java.io.IOException;

public class SwitchAction
implements ProtocolAction,
Cloneable {
    Class<? extends Protocol>[] protocolClasses;
    Class<? extends AbstractProtocol> defaultSwitch;

    public SwitchAction(Class<? extends Protocol>[] protocolClasses) {
        this.protocolClasses = protocolClasses;
    }

    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException {
        DataTransport transport = parentProtocol.getTransport();
        byte protocolNumber = transport.readByte();
        parentProtocol.serverSideProcess(this.protocolClasses[protocolNumber]);
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException {
        int protocolNumber = this.findProtocolNumber();
        DataTransport transport = parentProtocol.getTransport();
        transport.writeByte(protocolNumber);
    }

    private int findProtocolNumber() {
        int protocolNumber = 0;
        System.out.println(" findProtocolNumber with defaultSwitch =  " + this.defaultSwitch);
        for (Class<? extends Protocol> protocol : this.protocolClasses) {
            if (protocol == this.defaultSwitch) {
                return protocolNumber;
            }
            ++protocolNumber;
        }
        throw new RuntimeException("unable to find protocol number for defaultSwitch = " + this.defaultSwitch);
    }

    public SwitchAction newClone() {
        try {
            return (SwitchAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setClientSwitch(Class<? extends AbstractProtocol> protocol) {
        this.defaultSwitch = protocol;
    }
}

