/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import java.io.IOException;

public class VerifyClientIDAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        String idName;
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        if (serverHandler.isIdInstalled(idName = tr.readUTF())) {
            PublicID publicID = serverHandler.getInstalledID(idName);
            byte[] randomBytes = JSlopeRandom.getRandom(1024);
            tr.writeBytes(randomBytes);
            byte[] signature = tr.readBytes();
            boolean signatureIsOk = publicID.verifySignature(randomBytes, signature);
            if (signatureIsOk) {
                System.out.println("Signature is ok");
                tr.writeByte((byte)1);
                parentProtocol.setValue(ProtocolConstants.PUBLIC_ID, publicID);
            } else {
                System.out.println("Bad signature ok");
                tr.writeByte((byte)12);
                parentProtocol.throwActionException("Bad signature", "Bad signature on client side");
            }
        } else {
            System.out.println("Id " + idName + " not installed");
            tr.writeByte((byte)14);
            parentProtocol.throwActionException("ID not installed", "ID " + idName + " is not installe on this server ");
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        SecureID secureID = (SecureID)parentProtocol.getValue(ProtocolConstants.SECURE_ID);
        String idName = secureID.getName();
        tr.writeUTF(idName);
        byte[] bytesToSign = tr.readBytes();
        byte[] signature = secureID.signLowLevelBytes(bytesToSign);
        tr.writeBytes(signature);
        byte retValue = tr.readByte();
        if (retValue != 1) {
            switch (retValue) {
                case 12: {
                    parentProtocol.throwActionException("Bad signature", "Bad signature on client side for id " + idName);
                }
                case 14: {
                    parentProtocol.throwActionException("ID not installed", "ID " + idName + " is not installe on this server ");
                }
            }
            parentProtocol.throwActionException("Unkown error", "Unkown error while verifyng signature for id " + idName);
        }
    }
}

