/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.messages;

import com.jslope.io.protocol.messages.AttachmentObject;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.security.crypto.utils.Utils;
import java.io.IOException;

public class FileAttachmentObject
implements AttachmentObject {
    String name;
    byte[] content;

    @Override
    public void setFile(String fileName, byte[] bytes) {
        this.name = fileName;
        this.content = bytes;
    }

    @Override
    public boolean isEqual(AttachmentObject attachmentObject) {
        return this.name.equals(attachmentObject.getName()) && Utils.compareBytes(this.content, attachmentObject.getContent());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void serialize(AdvancedDataOutput os) throws IOException {
        os.writeUTF(this.name);
        os.writeBytes(this.content);
    }

    @Override
    public void deserialize(AdvancedDataInput is) throws IOException {
        this.name = is.readUTF();
        this.content = is.readBytes();
    }

    public String toString() {
        return this.getName();
    }
}

