/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence;

import com.jslope.persistence.Config;
import com.jslope.persistence.LoadException;
import com.jslope.persistence.ObjectCache;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.PersistenceException;
import com.jslope.persistence.Type;
import com.jslope.persistence.Types;
import com.jslope.persistence.fields.BlobField;
import com.jslope.persistence.fields.Field;
import com.jslope.persistence.fields.IDField;
import com.jslope.persistence.sql.BasicCondition;
import com.jslope.persistence.sql.Condition;
import com.jslope.persistence.sql.Limit;
import com.jslope.persistence.sql.LogicCondition;
import com.jslope.persistence.sql.QueryException;
import com.jslope.persistence.sql.ResultIterator;
import com.jslope.persistence.sql.ResultRow;
import com.jslope.persistence.sql.SqlUtil;
import com.jslope.persistence.utils.IDGen;
import com.jslope.persistence.utils.Pair;
import com.jslope.persistence.utils.UtilMisc;
import com.jslope.utils.Log;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class DBPersistentObject {
    static ObjectCache objectCache = ObjectCache.getInstance();
    private HashMap<String, Field> fields = new HashMap();
    protected ArrayList<String> classFieldNames = new ArrayList();
    private String objectID = null;
    private int classID;
    private boolean stateChanged = false;
    private boolean isNewObject = true;
    public static String FIELDS_TABLE = Config.getFieldsTableName();
    public static final String ID_FIELD_NAME = "OBJECT_ID";
    private int unsaveableFields = 0;
    public static final int defaultOrder = -1;
    private static Set<String> fieldsChecked = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBPersistentObject() {
        this.getOrder();
        this.addField(ID_FIELD_NAME, new IDField());
        if (!this.sqlTypeExists()) {
            ObjectCache objectCache = DBPersistentObject.objectCache;
            synchronized (objectCache) {
                if (!this.sqlTypeExists()) {
                    this.createSQLType();
                }
            }
        }
        Class<?> thisClass = this.getClass();
        this.setTypeID(Types.get(thisClass.getName()));
        this.setUnique(ID_FIELD_NAME);
        this.define();
        this.checkFieldsWithTableFields();
    }

    private void setUnique(String fieldName) {
        this.getField(fieldName).setUnique(true);
    }

    protected boolean sqlTypeExists() {
        return Types.typeExists(this.getClass().getName());
    }

    protected int getOrder() {
        return -1;
    }

    protected void createSQLType() {
        String name = this.getClass().getName();
        if (this.getOrder() != -1) {
            Types.addType(name, this.getOrder());
        } else {
            Types.addType(name);
        }
        String tableName = Types.getTableName(name);
        SqlUtil.createTable(tableName);
    }

    public abstract void define();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFieldsWithTableFields() {
        if (!this.fieldsHaveBeenChecked()) {
            ObjectCache objectCache = DBPersistentObject.objectCache;
            synchronized (objectCache) {
                if (!this.fieldsHaveBeenChecked()) {
                    this.realFieldsCheck();
                }
            }
        }
    }

    public static void initFieldsChecked() {
        fieldsChecked = new HashSet<String>();
    }

    private boolean fieldsHaveBeenChecked() {
        return fieldsChecked.contains(this.getTableName());
    }

    private void realFieldsCheck() {
        fieldsChecked.add(this.getTableName());
        Hashtable databaseFields = Types.getFieldList(this.getTypeID());
        for (String fieldName : this.classFieldNames) {
            if (databaseFields.containsKey(fieldName)) {
                String fieldType = (String)databaseFields.get(fieldName);
                if (this.getField(fieldName).equalsSQLType(fieldType)) continue;
                this.updateSQLType(fieldName, fieldType);
                continue;
            }
            this.addSQLField(fieldName);
        }
        Enumeration fieldKeys = databaseFields.keys();
        while (fieldKeys.hasMoreElements()) {
            String fieldName;
            fieldName = (String)fieldKeys.nextElement();
            if (this.classFieldNames.contains(fieldName)) continue;
            this.removeSQLField(fieldName);
        }
    }

    private void addSQLField(String fieldName) {
        Field field = this.getField(fieldName);
        SqlUtil.addField(this.getTableName(), fieldName, field.getSQLType());
        if (field.isUnique()) {
            SqlUtil.addUnique(this.getTableName(), fieldName);
        }
        if (field.isIndexed()) {
            SqlUtil.addIndex(this.getTableName(), fieldName);
        }
        if (field.isSetDefaultValue()) {
            SqlUtil.update(this.getTableName(), UtilMisc.toPair(fieldName, field.getDefaultValue()), null);
        }
        SqlUtil.insert(FIELDS_TABLE, UtilMisc.toPair("TypeID1", new Integer(this.getTypeID()), "FieldName", fieldName, "FieldType", field.getSQLType()));
    }

    private void removeSQLField(String fieldName) {
        SqlUtil.removeField(this.getTableName(), fieldName);
        SqlUtil.delete(FIELDS_TABLE, UtilMisc.toPair("TypeID1", new Integer(this.getTypeID()), "FieldName", fieldName));
    }

    private void updateSQLType(String fieldName, String fieldType) {
        String sqlType = this.getField(fieldName).getSQLType();
        SqlUtil.updateField(this.getTableName(), fieldName, fieldType, sqlType);
        SqlUtil.update(FIELDS_TABLE, UtilMisc.toPair("FieldType", sqlType), UtilMisc.toPair("TypeID1", new Integer(this.getTypeID()), "FieldName", fieldName));
    }

    public String getTableName() {
        return Types.getTableName(this.getClass().getName());
    }

    public void addField(String name, Field f) {
        f.setName(name);
        if (this.hasField(name)) {
            throw new IllegalArgumentException("Field " + name + " already exists");
        }
        this.fields.put(name, f);
        this.classFieldNames.add(name);
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public void setField(String name, Field f) {
        if (!this.hasField(name)) {
            throw new IllegalArgumentException("No such field " + name);
        }
        this.fields.put(name, f);
        this.stateChanged = true;
    }

    public Field getField(String name) {
        if (this.hasField(name)) {
            return this.fields.get(name);
        }
        System.out.println(" there is no such field " + name);
        return null;
    }

    public void set(String name, String value) {
        this.getField(name).setValue(value);
        this.stateChanged = true;
    }

    public String get(String name) {
        return this.getField(name).getValue();
    }

    public static int classIDFromObjectID(String objectId) {
        return Integer.parseInt(objectId.substring(0, 3));
    }

    public static DBPersistentObject getNewObject(String id) {
        return DBPersistentObject.getNewObject(DBPersistentObject.classIDFromObjectID(id));
    }

    public static DBPersistentObject getNewObject(int id) {
        Type type = Types.getType(id);
        DBPersistentObject object = null;
        try {
            Class<?> clas = Class.forName(type.getClassName());
            object = (DBPersistentObject)clas.getConstructor(new Class[0]).newInstance(new Object[0]);
            object.setIsNew(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public void reload() throws LoadException {
        this.load(this.getID());
    }

    private void load(String loadObjectId) throws LoadException {
        try {
            this.loadWhere(UtilMisc.toPair(ID_FIELD_NAME, loadObjectId));
        }
        catch (LoadException e) {
            e.printStackTrace();
            throw new LoadException("Could not load object with ID = " + loadObjectId);
        }
    }

    public void loadWhere(Pair[] condition) throws LoadException {
        try {
            String[] fieldNames = this.classFieldNames.toArray(new String[this.classFieldNames.size()]);
            ResultIterator result = SqlUtil.findByAnd(this.getTableName(), fieldNames, condition);
            if (!result.hasNext()) {
                throw new LoadException("There is no object with such condition: " + Pair.showPairs(condition));
            }
            this.loadFields(result, fieldNames);
        }
        catch (QueryException e) {
            throw new LoadException(e, e.getMessage());
        }
        this.afterLoad();
    }

    public void loadWhere(BasicCondition condition) throws LoadException {
        try {
            String[] fieldNames = this.classFieldNames.toArray(new String[this.classFieldNames.size()]);
            ResultIterator result = SqlUtil.find(this.getTableName(), fieldNames, condition);
            this.loadFields(result, fieldNames);
        }
        catch (QueryException e) {
            throw new LoadException(e, e.getMessage());
        }
        this.afterLoad();
    }

    protected void afterLoad() {
    }

    public boolean objectExists(BasicCondition condition) throws QueryException {
        ResultIterator result = SqlUtil.find(this.getTableName(), new String[]{ID_FIELD_NAME}, condition);
        return result.hasNext();
    }

    public boolean objectExists(String objID) {
        if (objectCache.hasObject(objID)) {
            return true;
        }
        return this.objectExists(Condition.var(ID_FIELD_NAME).Equal(objID));
    }

    public ObjectList loadObjects() throws QueryException {
        return this.loadObjects(null, null);
    }

    public ObjectList loadObjects(BasicCondition condition) throws QueryException {
        return this.loadObjects(condition, null);
    }

    public ObjectList loadObjects(BasicCondition condition, String[] orderBy) throws QueryException {
        ResultIterator result = SqlUtil.find(this.getTableName(), new String[]{ID_FIELD_NAME}, condition, orderBy);
        return new ObjectList(result);
    }

    public ObjectList loadObjects(BasicCondition condition, String[] orderBy, Limit limit) throws QueryException {
        ResultIterator result = SqlUtil.find(this.getTableName(), new String[]{ID_FIELD_NAME}, condition, orderBy, limit);
        return new ObjectList(result);
    }

    protected void loadFields(ResultIterator result, String[] fieldNames) throws LoadException {
        ResultRow row = result.next();
        if (row != null) {
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                Field field = this.getField(fieldName);
                if (field instanceof BlobField) {
                    BlobField blob = (BlobField)field;
                    Object obj = row.getObject(fieldName);
                    blob.setBlob((Blob)obj);
                    continue;
                }
                String value = row.getString(fieldName);
                field.setValue(SqlUtil.decode(value));
            }
        } else {
            throw new LoadException("Could not load object ");
        }
        this.setID(this.get(ID_FIELD_NAME));
        this.setIsNew(false);
    }

    public void deleteObject() {
        System.out.println("\n\n\nnow deleting " + this + " id:" + this.getID() + "\n\n\n");
        SqlUtil.delete(this.getTableName(), UtilMisc.toPair(ID_FIELD_NAME, this.getID()));
        objectCache.remove(this);
    }

    public void deleteObjects(BasicCondition condition) {
        SqlUtil.delete(this.getTableName(), condition);
    }

    public static DBPersistentObject loadObject(String objectID) throws LoadException {
        if (objectCache.hasObject(objectID)) {
            return objectCache.get(objectID);
        }
        DBPersistentObject object = DBPersistentObject.getNewObject(objectID);
        object.load(objectID);
        objectCache.add(object);
        return object;
    }

    public DBPersistentObject loadOneObject(LogicCondition condition) throws LoadException {
        return this.loadOneObject(condition, null);
    }

    public DBPersistentObject loadOneObject(BasicCondition condition) throws LoadException {
        return this.loadOneObject(condition, null);
    }

    public DBPersistentObject loadOneObject(BasicCondition condition, String[] orderBy) throws LoadException {
        ObjectList result = this.loadObjects(condition, orderBy);
        if (result.hasNext()) {
            return result.next();
        }
        throw new LoadException("Unable to find object with condition: " + condition);
    }

    public static void deleteObject(String objectID) {
        int classId = Integer.parseInt(objectID.substring(0, 3));
        Type type = Types.getType(classId);
        String tableName = type.getTableName();
        SqlUtil.delete(tableName, UtilMisc.toPair(ID_FIELD_NAME, objectID));
    }

    public void save() throws PersistenceException {
        this.beforeSave();
        this.getID();
        if (this.stateChanged && !this.validate()) {
            throw new PersistenceException("Object not valid");
        }
        String tableName = this.getTableName();
        if (this.isNew()) {
            this.insertObject(tableName);
            this.isNewObject = false;
            objectCache.add(this);
        } else {
            SqlUtil.update(tableName, this.objectFields(), new Pair[]{new Pair(ID_FIELD_NAME, this.getID())});
        }
    }

    protected void beforeSave() {
    }

    private Pair[] objectFields() {
        int returningFields = 0;
        int howManyFields = this.classFieldNames.size() - this.unsaveableFields;
        Pair[] returnFields = new Pair[howManyFields];
        for (int i = 0; i < this.classFieldNames.size(); ++i) {
            String fieldName = this.classFieldNames.get(i);
            Field field = this.getField(fieldName);
            if (field.isUnSaveable()) continue;
            Object value = field instanceof BlobField ? ((BlobField)field).getBlob() : SqlUtil.encode(field.getValue());
            returnFields[returningFields] = new Pair(fieldName, value);
            ++returningFields;
        }
        return returnFields;
    }

    private boolean validate() {
        Iterator<Field> it = this.fields.values().iterator();
        boolean valid = true;
        while (it.hasNext()) {
            Field field = it.next();
            if (field.validate()) continue;
            valid = false;
            Log.debug("invalid field is " + field.getName() + " type=" + field.getClass() + " with value = " + field.getValue() + " error message:" + field.getErrorMessage());
        }
        return valid;
    }

    private void insertObject(String tableName) {
        SqlUtil.insert(tableName, this.objectFields());
    }

    public void setID(String id) {
        boolean wasRemoved = false;
        if (this.objectID != null) {
            objectCache.remove(this);
            wasRemoved = true;
            System.out.println(" removed ID from cache");
        }
        this.objectID = id;
        this.set(ID_FIELD_NAME, this.objectID);
        if (wasRemoved) {
            objectCache.add(this);
        }
    }

    public String getID() {
        if (this.objectID == null) {
            this.setID(String.valueOf(DBPersistentObject.normalize("" + this.getTypeID())) + "-" + IDGen.generateUID());
        }
        return this.objectID;
    }

    private void setIsNew(boolean isNew) {
        this.isNewObject = isNew;
    }

    protected void setTypeID(int classID) {
        this.classID = classID;
    }

    private int getTypeID() {
        return this.classID;
    }

    public boolean isNew() {
        return this.isNewObject;
    }

    public void setUnsaveableField(String fieldName) {
        this.getField(fieldName).setUnSaveable(true);
        ++this.unsaveableFields;
    }

    private static String normalize(String s) {
        while (s.length() < 3) {
            s = "0" + s;
        }
        return s;
    }

    public static boolean existsObject(String id) {
        DBPersistentObject obj = DBPersistentObject.getNewObject(id);
        return obj.objectExists(Condition.var(ID_FIELD_NAME).Equal(id));
    }

    public void copyFrom(DBPersistentObject obj) {
        for (String fieldName : this.fields.keySet()) {
            this.set(fieldName, obj.get(fieldName));
        }
    }

    public void deleteAll() {
        SqlUtil.deleteAll(this.getTableName());
    }

    protected void setIndex(String fieldName) {
        this.getField(fieldName).setIndexed(true);
    }

    public long count(BasicCondition condition) {
        return SqlUtil.count(this.getTableName(), condition);
    }
}

