/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.fields;

import com.jslope.persistence.fields.Field;
import com.jslope.persistence.sql.SqlUtil;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;

public class BlobField
extends Field {
    private byte[] data;

    @Override
    public String getSQLType() {
        return SqlUtil.getSqlServer().getTypeForBlob();
    }

    public void setBlob(Blob blob) {
        try {
            this.data = blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Blob decoding exception", e);
        }
    }

    public Blob getBlob() {
        try {
            return new SerialBlob(this.data);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Blob encoding exception", e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataSize() {
        return this.data.length;
    }

    public void setData(byte[] newData) {
        this.data = newData;
    }
}

