/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.sql;

import com.jslope.persistence.sql.DefaultSqlServer;

public class MsSqlServer
extends DefaultSqlServer {
    @Override
    public String formatField(String fieldName) {
        return fieldName;
    }

    @Override
    public String formatValue(String fieldName) {
        return this.surround(fieldName.replaceAll("'", "''"), '\'');
    }

    @Override
    public void addField(String tableName, String fieldName, String fieldType) {
        String sql = "ALTER TABLE " + tableName + " ADD " + this.formatField(fieldName) + " " + fieldType + "";
        MsSqlServer.executeUpdate(sql);
    }

    public void changeFieldName(String tableName, String oldFieldName, String newFieldName) {
        String sql = "EXEC sp_rename " + this.formatValue(tableName + "." + oldFieldName) + ", " + this.formatValue(newFieldName) + ", " + this.formatValue("COLUMN");
        MsSqlServer.executeUpdate(sql);
    }

    @Override
    public String getTypeForNumber(int decimalSize, int floatSize) {
        return "DECIMAL(" + decimalSize + ", " + floatSize + ")";
    }

    @Override
    public String getTypeForDate() {
        return "DATETIME";
    }

    @Override
    public void deploy() {
        DefaultSqlServer.executeUpdate("CREATE TABLE " + this.types + " (ClassID INT IDENTITY(1,1))");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.types + " ADD ClassName VARCHAR(200)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.types + " ADD TableName VARCHAR(50)");
        DefaultSqlServer.executeUpdate("CREATE TABLE " + this.fields + " (" + "TypeID1" + " INT NOT NULL)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.fields + " ADD FieldName VARCHAR(200)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.fields + " ADD FieldType VARCHAR(200)");
    }
}

