/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.sql;

import com.jslope.persistence.Config;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.Types;
import com.jslope.persistence.sql.BasicCondition;
import com.jslope.persistence.sql.Limit;
import com.jslope.persistence.sql.QueryException;
import com.jslope.persistence.sql.ResultIterator;
import com.jslope.persistence.sql.SqlServer;
import com.jslope.persistence.utils.Pair;

public class SqlUtil {
    private static SqlServer sqlServer;

    private static void initialize() {
        String className = Config.getSqlServerHandler();
        try {
            Class<?> c = Class.forName(className);
            sqlServer = (SqlServer)c.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static boolean insert(String tableName, Pair[] fields) {
        return sqlServer.insert(tableName, fields);
    }

    public static void delete(String tableName, Pair[] conditionFields) {
        sqlServer.delete(tableName, conditionFields);
    }

    public static void deleteAll(String tableName) {
        sqlServer.deleteAll(tableName);
    }

    public static void delete(String tableName, BasicCondition conditionFields) {
        sqlServer.delete(tableName, conditionFields);
    }

    public static void update(String tableName, Pair[] setFields, Pair[] conditionFields) {
        sqlServer.update(tableName, setFields, conditionFields);
    }

    public static ResultIterator findAll(String tableName) throws QueryException {
        return sqlServer.findAll(tableName);
    }

    public static ResultIterator findByAnd(String tableName, String[] fields, Pair[] where, String[] orderBy) throws QueryException {
        return sqlServer.findByAnd(tableName, fields, where, orderBy);
    }

    public static ResultIterator findByAnd(String tableName, String[] fields, Pair[] where) throws QueryException {
        return sqlServer.findByAnd(tableName, fields, where);
    }

    public static void createTable(String tableName) {
        sqlServer.createTable(tableName);
    }

    public static void dropTable(String tableName) {
        sqlServer.dropTable(tableName);
    }

    public static void addField(String tableName, String fieldName, String fieldType) {
        sqlServer.addField(tableName, fieldName, fieldType);
    }

    public static void removeField(String tableName, String fieldName) {
        sqlServer.removeField(tableName, fieldName);
    }

    public static void updateField(String tableName, String fieldName, String fieldType, String newType) {
        sqlServer.updateField(tableName, fieldName, fieldType, newType);
    }

    public static void changeFieldName(String tableName, String oldFieldName, String newFieldName, String fieldType) {
        sqlServer.changeFieldName(tableName, oldFieldName, newFieldName, fieldType);
    }

    public static SqlServer getSqlServer() {
        return sqlServer;
    }

    public static ResultIterator find(String tableName, String[] fieldNames, BasicCondition condition) throws QueryException {
        return sqlServer.find(tableName, fieldNames, condition, null);
    }

    public static ResultIterator find(String tableName, String[] fieldNames, BasicCondition condition, String[] orderBy) throws QueryException {
        return sqlServer.find(tableName, fieldNames, condition, orderBy);
    }

    public static ResultIterator find(String tableName, String[] fieldNames, BasicCondition condition, String[] orderBy, Limit limit) throws QueryException {
        return sqlServer.find(tableName, fieldNames, condition, orderBy, limit);
    }

    public static String encode(String str) {
        return sqlServer.encode(str);
    }

    public static String decode(String str) {
        return sqlServer.decode(str);
    }

    public static void closeDatabase() {
        sqlServer.close();
    }

    public static void addUnique(String tableName, String fieldName) {
        sqlServer.addUnique(tableName, fieldName);
    }

    public static void clearDB() {
        for (String string : Types.getTableNames()) {
            SqlUtil.dropTable(Types.getTableName(string));
        }
        SqlUtil.dropTable(Config.getTypesTableName());
        SqlUtil.dropTable(Config.getFieldsTableName());
        sqlServer.deploy();
        Types.getInstance().reinitTypes();
        DBPersistentObject.initFieldsChecked();
    }

    public static void addIndex(String tableName, String fieldName) {
        sqlServer.addIndex(tableName, fieldName);
    }

    public static long count(String tableName, BasicCondition condition) {
        return sqlServer.count(tableName, condition);
    }

    static {
        SqlUtil.initialize();
    }
}

