/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.impl;

import com.jslope.security.crypto.JSlopeKeyPair;
import com.jslope.security.crypto.impl.RSAPrivateKey;
import com.jslope.security.crypto.impl.RSAPublicKey;
import com.jslope.security.crypto.utils.JSlopeRandom;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;

public class RSAKeyPair
implements JSlopeKeyPair {
    static final int DEFAULT_KEY_CERTAINTY = 25;
    static final BigInteger publicExponent = BigInteger.valueOf(17L);
    static final int KEY_LENGTH = 2048;
    RSAPrivateKey privateKey;
    RSAPublicKey publicKey;
    private AsymmetricCipherKeyPair pair;

    @Override
    public void generate() {
        SecureRandom random = JSlopeRandom.getSecureRandom();
        RSAKeyGenerationParameters kgp = new RSAKeyGenerationParameters(publicExponent, random, 2048, 25);
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        kpg.init((KeyGenerationParameters)kgp);
        this.pair = kpg.generateKeyPair();
        this.privateKey = new RSAPrivateKey(this.pair.getPrivate());
        this.publicKey = new RSAPublicKey(this.pair.getPublic());
    }

    @Override
    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

