/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.impl;

import com.jslope.logger.Log;
import com.jslope.security.crypto.JSlopeSymetricKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class TwofishSymetricKey
implements JSlopeSymetricKey {
    private final BlockCipher engine = new TwofishEngine();
    public static final int KEY_SIZE = 256;
    byte[] key;
    private BufferedBlockCipher cipher;

    @Override
    public byte[] encrypt(byte[] message) throws CryptogException {
        this.init(true);
        return this.process(message);
    }

    private byte[] process(byte[] message) throws CryptogException {
        byte[] out = new byte[this.cipher.getOutputSize(message.length)];
        int len1 = this.cipher.processBytes(message, 0, message.length, out, 0);
        try {
            int len2 = this.cipher.doFinal(out, len1);
            if (len1 + len2 < message.length) {
                byte[] newOut = new byte[len1 + len2];
                System.arraycopy(out, 0, newOut, 0, newOut.length);
                out = newOut;
            }
        }
        catch (InvalidCipherTextException e) {
            Log.error("Exception occured in TwofishSymetricKey for message with len = " + message.length, (Exception)((Object)e));
            e.printStackTrace();
            throw new CryptogException((Exception)((Object)e));
        }
        return out;
    }

    @Override
    public byte[] decrypt(byte[] encrypted) throws CryptogException {
        this.init(false);
        return this.process(encrypted);
    }

    @Override
    public void generate() throws CryptogException {
        this.key = JSlopeRandom.getRandom(256);
    }

    @Override
    public void init(byte[] newKey) {
        this.key = newKey;
    }

    @Override
    public byte[] getBytes() {
        return this.key;
    }

    private void init(boolean forEncryption) {
        this.cipher = new PaddedBufferedBlockCipher(this.engine);
        this.cipher.init(forEncryption, (CipherParameters)new KeyParameter(this.key));
    }
}

