/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.utils;

import com.jslope.io.stream.StreamSerializable;
import com.jslope.io.stream.impl.AdvancedByteDataInputStream;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import java.io.IOException;

public class Utils {
    private static String digits = "0123456789abcdef";

    public static boolean compareBytes(byte[] ar1, byte[] ar2) {
        if (ar1.length != ar2.length) {
            return false;
        }
        for (int i = 0; i < ar1.length; ++i) {
            if (ar1[i] == ar2[i]) continue;
            return false;
        }
        return true;
    }

    public static String showBytes(byte[] arr) {
        StringBuffer buf = new StringBuffer();
        boolean notFirstTime = false;
        for (int i = 0; i < arr.length; ++i) {
            if (notFirstTime) {
                buf.append(", ");
            } else {
                notFirstTime = true;
            }
            int v = arr[i] & 0xFF;
            if (v > 127) {
                buf.append("(byte)");
            }
            buf.append("0x");
            buf.append(digits.charAt(v >> 4));
            buf.append(digits.charAt(v & 0xF));
        }
        return buf.toString();
    }

    public static byte[] stringToBytes(String message) {
        AdvancedByteDataOutputStream os = new AdvancedByteDataOutputStream();
        try {
            os.writeUTF(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return os.toByteArray();
    }

    public static String bytesToString(byte[] message) {
        AdvancedByteDataInputStream is = new AdvancedByteDataInputStream(message);
        try {
            return is.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serializeToBytes(StreamSerializable obj) {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            obj.serialize(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }
}

