/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.security.Domain;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.JSlopePublicID;
import com.jslope.security.impl.JSlopeSecureID;
import java.io.File;
import java.io.IOException;

public class IDFactory {
    public static String idName(String prefix, String domainName) {
        return prefix + "@" + domainName;
    }

    public static SecureID newID() {
        return new JSlopeSecureID();
    }

    public static SecureID newID(String name) {
        SecureID id = IDFactory.newID();
        id.setName(name);
        id.generate();
        return id;
    }

    public static SecureID loadIDFromFile(File file) throws IOException {
        SecureID id = IDFactory.newID();
        id.loadFromFile(file);
        return id;
    }

    public static PublicID newPublicID() {
        return new JSlopePublicID();
    }

    public static PublicID deserializePublicID(AdvancedDataInput is) throws IOException {
        PublicID publicID = IDFactory.newPublicID();
        publicID.deserialize(is);
        return publicID;
    }

    public static SecureID deserializeSecureID(AdvancedDataInput is) throws IOException {
        SecureID secureID = IDFactory.newID();
        secureID.deserialize(is);
        return secureID;
    }

    public static String getDomainName(String idName) {
        String[] rezult = idName.split("@");
        try {
            return rezult[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("ArrayIndex out of bound when trying to extract domain from id: " + idName, e);
        }
    }

    public static SecureID newIDSignedByDomain(Domain domain, String serverIDname) throws CryptogException {
        SecureID secureID = IDFactory.newID(serverIDname);
        PublicID publicID = secureID.getPublicPart();
        domain.signID(publicID);
        secureID.reintegrate(publicID);
        return secureID;
    }
}

