/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.uirandom;

import com.jslope.uirandom.UpdateListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;

public class RandomByteKeeper
extends MouseMotionAdapter
implements KeyListener {
    protected byte[] seedBytes;
    protected int bitIndex;
    protected boolean isDone;
    List<ActionListener> actionListeners = new Vector<ActionListener>();
    List<UpdateListener> updateListeners = new Vector<UpdateListener>();
    int oldX = 0;
    int oldY = 0;
    static final int mousePrecisionLimit = 25;

    public RandomByteKeeper(int howManyBytes) {
        this.reset(howManyBytes);
    }

    public void reset(int howManyBytes) {
        this.seedBytes = new byte[howManyBytes];
        this.bitIndex = howManyBytes * 8 - 1;
        this.isDone = false;
    }

    public byte[] getSeed() {
        return this.seedBytes;
    }

    public int getBitLength() {
        return this.seedBytes.length * 8;
    }

    public int getCurrentBitIndex() {
        return this.seedBytes.length * 8 - 1 - this.bitIndex;
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.getKeyChar();
        this.updateBit();
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    protected void addTimeBit() {
        if (this.isDone) {
            return;
        }
        long t = System.nanoTime();
        long bit = 1L & t;
        if (bit != 0L) {
            int seedIndex = this.bitIndex / 8;
            int shiftIndex = this.bitIndex % 8;
            int n = seedIndex;
            this.seedBytes[n] = (byte)((long)this.seedBytes[n] | bit << shiftIndex);
        }
        --this.bitIndex;
        if (this.bitIndex < 0) {
            this.bitIndex = 0;
            this.isDone = true;
            ActionEvent event = new ActionEvent(this, 0, "Your seed is ready.");
            for (ActionListener al : this.actionListeners) {
                al.actionPerformed(event);
            }
        }
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    private void fireUpdateListener() {
        for (UpdateListener ul : this.updateListeners) {
            ul.update();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int newX = event.getX();
        int newY = event.getY();
        if (newX / 25 != this.oldX / 25 && newY / 25 != this.oldY / 25) {
            this.updateBit();
            this.oldX = newX;
            this.oldY = newY;
        }
    }

    private void updateBit() {
        this.addTimeBit();
        this.fireUpdateListener();
    }
}

