/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.Cursor;
import org.h2.index.PageDataLeaf;
import org.h2.result.Row;
import org.h2.result.SearchRow;

class PageScanCursor
implements Cursor {
    private PageDataLeaf current;
    private int index;
    private Row row;

    PageScanCursor(PageDataLeaf pageDataLeaf, int n) {
        this.current = pageDataLeaf;
        this.index = n;
    }

    public Row get() {
        return this.row;
    }

    public int getPos() {
        return this.row.getPos();
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean next() throws SQLException {
        if (this.index >= this.current.getEntryCount()) {
            this.current = this.current.getNextPage();
            this.index = 0;
            if (this.current == null) {
                return false;
            }
        }
        this.row = this.current.getRowAt(this.index);
        ++this.index;
        return true;
    }

    public boolean previous() {
        --this.index;
        return true;
    }
}

