/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.client.ui.dialog.IDDialogField;
import com.jslope.client.ui.dialog.impl.IDEditField;
import com.jslope.client.ui.model.DirectoryTreeModel;
import com.jslope.io.server.DefaultServerConfiguration;
import com.jslope.security.Domain;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.utils.Validators;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConfigureServerDialog
extends AbstractOkCancelDialog {
    private JTextField address;
    private IDDialogField serverIDField;
    private IDDialogField rootIDField;
    private Domain domain;

    private ConfigureServerDialog(Domain selectedDomain) {
        super(MainWindow.getInstance(), "Configure New Server", false);
        this.domain = selectedDomain;
        JLabel domainName = new JLabel(this.domain.getName());
        this.addComponent("domainName:", domainName);
        this.address = new JTextField(15);
        this.addComponent("address:", this.address);
        this.serverIDField = new IDEditField(this.domain, "server id");
        this.addComponent(this.serverIDField);
        this.rootIDField = new IDEditField(this.domain, "root id");
        this.addComponent(this.rootIDField);
        this.finishDialog();
    }

    @Override
    protected boolean validateAction() throws CryptogException {
        String serverAddress = this.getServerAddress();
        String serverIDName = this.getServerIDName();
        String rootIDName = this.getRootIDName();
        if (!Validators.validateAddress(serverAddress)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server address", "Server address is invalid", 0);
            return false;
        }
        if (!Validators.validateIDName(serverIDName)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server ID", "Server ID is invalid", 0);
            return false;
        }
        if (!Validators.validateIDName(rootIDName)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid root ID", "Root ID is invalid", 0);
            return false;
        }
        if (serverIDName.equals(rootIDName)) {
            JOptionPane.showMessageDialog(this, "<html>You can't use same ID as server ID and root ID<br>root ID is controlling id, while server ID is server identification ID", "Server ID and Root ID can't be equal", 0);
            return false;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showDialog(this, "Select directory to save server configuration");
        if (returnVal == 0) {
            UIErrorHandler errorHandler = new UIErrorHandler(this);
            SecureID serverID = IDFactory.newIDSignedByDomain(this.domain, serverIDName);
            SecureID rootID = IDFactory.newIDSignedByDomain(this.domain, rootIDName);
            DefaultServerConfiguration configuration = new DefaultServerConfiguration(this.domain, serverAddress, serverID, rootID.getPublicPart(), errorHandler);
            if (!errorHandler.hasErrors()) {
                DirectoryTreeModel.addAccount(rootID);
                File directoryToSaveTo = fc.getSelectedFile();
                System.out.println("Is directory" + directoryToSaveTo.isDirectory());
                System.out.println("dir: " + directoryToSaveTo);
                try {
                    configuration.save(directoryToSaveTo);
                }
                catch (IOException e) {
                    errorHandler.addError("Unable to save file", "Unable to save configuration file to " + directoryToSaveTo.getName(), e);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                JOptionPane.showMessageDialog(this, "<html>The configuration was created successfuly,<br> it now resides in directory<br><br>" + directoryToSaveTo, "Configuration created successfully", 1);
                return true;
            }
            return false;
        }
        return false;
    }

    private String getRootIDName() {
        return this.rootIDField.getFullIDName();
    }

    private String getServerAddress() {
        return this.address.getText();
    }

    private String getServerIDName() {
        return this.serverIDField.getFullIDName();
    }

    public static void installDomain(Domain selectedDomain) {
        new ConfigureServerDialog(selectedDomain).setVisible(true);
    }
}

