/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.io.serverlistener.DomainHandler;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.client.ui.dialog.IDDialogField;
import com.jslope.client.ui.dialog.impl.IDEditField;
import com.jslope.logger.Log;
import com.jslope.security.Domain;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.utils.Validators;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CreateIDPermissionDialog
extends AbstractOkCancelDialog {
    private JTextField secretKey;
    private Domain domain;
    private IDDialogField idDialog;

    private CreateIDPermissionDialog(Domain selectedDomain) {
        super(MainWindow.getInstance(), "Create Mail Account", false);
        this.domain = selectedDomain;
        JLabel domainName = new JLabel(selectedDomain.getName());
        this.addComponent("domainName:", domainName);
        this.idDialog = new IDEditField(this.domain, "Name");
        this.addComponent(this.idDialog);
        this.secretKey = new JTextField(15);
        this.addComponent("secret key", this.secretKey);
        this.finishDialog();
    }

    @Override
    protected boolean validateAction() {
        String idLocalName = this.getIDName();
        String secretKey = this.getSecretKey();
        String fullIDName = IDFactory.idName(idLocalName, this.domain.getName());
        if (!Validators.validateIDName(fullIDName)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server name", "Server name is invalid", 0);
            return false;
        }
        UIErrorHandler errorHandler = new UIErrorHandler(DomainManagerDialog.getInstance());
        Log.debug("Create ID 1: validation passed for id: " + fullIDName);
        return DomainHandler.createIDPermitAndInvokeServerListener(this.domain, fullIDName, secretKey, errorHandler);
    }

    private String getSecretKey() {
        return this.secretKey.getText();
    }

    private String getIDName() {
        return this.idDialog.getPrefixIDName();
    }

    public static void createID(Domain selectedDomain) {
        new CreateIDPermissionDialog(selectedDomain).setVisible(true);
    }
}

