/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.model;

import com.jslope.client.app.Icons;
import com.jslope.client.ui.model.AbstractDirectoryNode;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.persistent.DirectoryRecord;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.client.ui.view.Viewers;
import com.jslope.client.ui.view.ViewersPanel;
import com.jslope.client.ui.view.treeviewers.DirectoryViewer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class Directory
extends AbstractDirectoryNode {
    DirectoryRecord record = null;
    private static Map<String, Directory> recordToNode = new HashMap<String, Directory>();
    int numberOfMessages = -1;

    public Directory(DirectoryRecord dirRecord) {
        this.record = dirRecord;
        recordToNode.put(this.record.getID(), this);
    }

    public static Directory getNode(String directoryID) {
        return recordToNode.get(directoryID);
    }

    public static boolean hasNodeWithID(String selectedNodeID) {
        return recordToNode.containsKey(selectedNodeID);
    }

    @Override
    public DirectoryAccountTreeNode getChild(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getIndexOfChild(DirectoryAccountTreeNode child) {
        return 0;
    }

    @Override
    public void updateEditor() {
        System.out.println("This is direcotry: " + this.record.toString());
        ViewersPanel.select(Viewers.DIRECTORY_VIEWER);
        ((DirectoryViewer)Viewers.DIRECTORY_VIEWER.getViewer()).update(this);
    }

    @Override
    public DirectoryAccountTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void removeChild(DirectoryAccountTreeNode node) {
    }

    @Override
    public String getRecordID() {
        return this.record.getID();
    }

    @Override
    public boolean canCreateNewMessage() {
        return true;
    }

    @Override
    public boolean canCheckMailForAnAccount() {
        return true;
    }

    @Override
    public boolean canDeleteAnAccount() {
        return false;
    }

    @Override
    public Icon getIcon() {
        if (this.record.isTrashDirecotry()) {
            return Icons.trashFolder;
        }
        if (this.record.isInboxDirectory()) {
            return Icons.inboxFolder;
        }
        if (this.record.isSentDirectory()) {
            return Icons.sentFolder;
        }
        if (this.isSelected()) {
            return Icons.openFolder;
        }
        return Icons.closedFolder;
    }

    public String toString() {
        return this.record.toString() + this.numberOfChildrenAsString();
    }

    private String numberOfChildrenAsString() {
        if (this.getNumberOfChildren() > 0) {
            return " (" + this.getNumberOfChildren() + ")";
        }
        return "";
    }

    private int getNumberOfChildren() {
        if (this.numberOfMessages < 0) {
            this.updateNumberOfMessages();
        }
        return this.numberOfMessages;
    }

    public DirectoryRecord getRecord() {
        return this.record;
    }

    public void updateNumberOfMessages() {
        this.numberOfMessages = this.record.getNumberOfMessages();
    }

    public void setSelectedMessage(MessageRecord selectedMessage) {
        this.record.setSelectedMessage(selectedMessage);
        this.record.save();
    }

    public MessageRecord getSelectedMessage() {
        return this.record.getSelectedMessage();
    }
}

