/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.model;

import com.jslope.client.ui.model.AccountNode;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.model.RootNode;
import com.jslope.security.SecureID;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DirectoryTreeModel
implements TreeModel {
    RootNode rootNode;
    Set<TreeModelListener> modelListeners = new HashSet<TreeModelListener>();
    private static DirectoryTreeModel instance = new DirectoryTreeModel();

    DirectoryTreeModel() {
        this.rootNode = new RootNode();
        this.rootNode.loadChildren();
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DirectoryAccountTreeNode node = (DirectoryAccountTreeNode)parent;
        return node.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((DirectoryAccountTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DirectoryAccountTreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((DirectoryAccountTreeNode)parent).getIndexOfChild((DirectoryAccountTreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.modelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.modelListeners.remove(l);
    }

    public void notifyAboutNewNode(DirectoryAccountTreeNode node) {
        System.out.println("notifyAboutNewNode is called modelListeners.size() =" + this.modelListeners.size());
        DirectoryAccountTreeNode parent = node.getParent();
        TreeModelEvent e = new TreeModelEvent((Object)parent, parent.getPathToRoot(), new int[]{parent.getIndexOfChild(node)}, new Object[]{node});
        this.fireEventToListeners(e);
    }

    private void fireEventToListeners(TreeModelEvent e) {
        for (TreeModelListener listener : this.modelListeners) {
            listener.treeNodesInserted(e);
        }
    }

    public static DirectoryTreeModel getInstance() {
        return instance;
    }

    private void addNewAccount(AccountNode account) {
        this.rootNode.addAccount(account);
        this.notifyAboutNewNode(account);
    }

    public static void addAccount(SecureID secureID) {
        AccountNode account = new AccountNode();
        account.setSecureID(secureID);
        account.setName(secureID.getName());
        account.save();
        DirectoryTreeModel.getInstance().addNewAccount(account);
    }

    public static void deleteAccount(AccountNode accountNode) {
        DirectoryTreeModel.getInstance().removeNode(accountNode);
        accountNode.delete();
    }

    public static void updateNode(DirectoryAccountTreeNode node) {
        DirectoryTreeModel.getInstance().fireUpdateNode(node);
    }

    private void fireUpdateNode(DirectoryAccountTreeNode node) {
        DirectoryAccountTreeNode parent = node.getParent();
        this.fireTreeStructureChanged(this, parent.getPathToRoot(), new int[]{parent.getIndexOfChild(node)}, new Object[]{node});
    }

    protected void fireTreeStructureChanged(Object source, TreePath path, int[] childIndices, Object[] children) {
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        for (TreeModelListener l : this.modelListeners) {
            l.treeStructureChanged(e);
        }
    }

    private void removeNode(DirectoryAccountTreeNode node) {
        DirectoryAccountTreeNode parent = node.getParent();
        if (parent != null) {
            parent.removeChild(node);
            this.fireTreeStructureChanged(this, parent.getPathToRoot(), null, null);
        }
    }
}

