/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.persistent;

import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.VarcharField;
import com.jslope.persistence.sql.Condition;
import com.jslope.security.PublicID;
import com.jslope.security.impl.IDFactory;
import java.util.HashSet;
import java.util.Set;

public class WaitingUnsignedID
extends DBPersistentObject {
    private static final String ID_NAME = "idname";
    private static final String DOMAIN_NAME = "domainname";
    private static WaitingUnsignedID workObject = new WaitingUnsignedID();

    @Override
    public void define() {
        this.addField(ID_NAME, new VarcharField(355));
        this.addField(DOMAIN_NAME, new VarcharField(355));
    }

    public static Iterable<? extends String> getServers() {
        HashSet<String> serverNames = new HashSet<String>();
        ObjectList objectList = workObject.loadObjects();
        while (objectList.hasNext()) {
            WaitingUnsignedID wuID = (WaitingUnsignedID)objectList.next();
            serverNames.add(wuID.getServerName());
        }
        return serverNames;
    }

    private String getServerName() {
        return IDFactory.getDomainName(this.getIDName());
    }

    private String getIDName() {
        return this.get(ID_NAME);
    }

    private void setIDName(String idName) {
        this.set(ID_NAME, idName);
    }

    private void setDomainName(String domainName) {
        this.set(DOMAIN_NAME, domainName);
    }

    public static void addUnsignedIDToWaitFor(String idName) {
        WaitingUnsignedID newUID = new WaitingUnsignedID();
        newUID.setIDName(idName);
        newUID.setDomainName(IDFactory.getDomainName(idName));
        newUID.save();
    }

    public static void removeSignedIDs(Set<PublicID> signedIDs) {
        for (PublicID signedID : signedIDs) {
            WaitingUnsignedID.removeID(signedID.getName());
        }
    }

    private static void removeID(String name) {
        workObject.deleteObjects(Condition.var(ID_NAME).Equal(name));
    }

    public static boolean areThereMoreWaitingForDomain(String domainName) {
        ObjectList objectList = workObject.loadObjects(Condition.var(DOMAIN_NAME).Equal(domainName));
        return objectList.hasNext();
    }
}

