/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.view.treeviewers;

import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.view.treeviewers.AbstractViewer;
import com.jslope.client.ui.view.treeviewers.ViewerInterface;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AccountViewer
extends AbstractViewer
implements ViewerInterface {
    JTextField description;
    JLabel unsignedDescription;
    JPanel signedPanel;
    JPanel unsignedPanel;
    static final String SIGNED_PANEL = "signed panel";
    static final String UNSIGNED_PANEL = "unsigned panel";
    public CardLayout cardLayout = new CardLayout();
    boolean isSigned = false;
    AccountRecord accountRecord = null;

    public AccountViewer() {
        this.panel.setLayout(this.cardLayout);
        this.signedPanel = new JPanel();
        this.signedPanel.setLayout(new BoxLayout(this.signedPanel, 1));
        this.description = new JTextField(50);
        this.description.setText("Empty description");
        this.description.setEditable(false);
        this.signedPanel.add(this.description);
        this.unsignedPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        this.unsignedDescription = new JLabel();
        this.unsignedDescription.setText("Empty description");
        innerPanel.add(Box.createVerticalStrut(50));
        innerPanel.add(this.unsignedDescription);
        JButton checkServer = new JButton("Check server for signed ID");
        innerPanel.add(checkServer);
        checkServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountViewer.this.startCheckingSignature();
            }
        });
        this.unsignedPanel.add("Center", innerPanel);
        this.panel.add(SIGNED_PANEL, this.signedPanel);
        this.panel.add(UNSIGNED_PANEL, this.unsignedPanel);
    }

    private void startCheckingSignature() {
        AccountRecord.checkSignature(this.accountRecord);
    }

    public void setIsSigned(boolean isSigned) {
        this.isSigned = isSigned;
        if (isSigned) {
            this.cardLayout.show(this.panel, SIGNED_PANEL);
        } else {
            this.cardLayout.show(this.panel, UNSIGNED_PANEL);
        }
    }

    public void setIDRecord(AccountRecord record) {
        this.accountRecord = record;
        if (this.isSigned) {
            this.description.setText("Signed id: " + this.accountRecord.toString());
        } else {
            this.unsignedDescription.setText("Unsigned id: " + this.accountRecord.toString());
        }
    }

    @Override
    public void savePersistentState() {
    }
}

