/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.view.treeviewers;

import com.jslope.client.app.Actions;
import com.jslope.client.app.Options;
import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.persistent.AttachmentRef;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.client.ui.view.attachments.AttachmentList;
import com.jslope.client.ui.view.elements.MessageHeaderPanel;
import com.jslope.client.ui.view.treeviewers.MessagePopup;
import com.jslope.client.ui.view.treeviewers.MessageTableModel;
import com.jslope.client.ui.view.treeviewers.ViewerInterface;
import com.jslope.logger.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class DirectoryViewer
implements ViewerInterface {
    JPanel panel = null;
    public JSplitPane splitPane;
    JSplitPane attchmntSplit;
    public JTable messagesTable;
    public JTextPane messageText;
    MessageHeaderPanel messageHeader;
    MessageTableModel tableModel;
    Component attachments;
    AttachmentList attachmentList;
    int attDividerLocation = 0;
    Directory previousDirectory = null;

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.initPanel();
        }
        return this.panel;
    }

    @Override
    public void savePersistentState() {
        Options options = Options.getInstance();
        options.setHorisontalSplit(this.splitPane.getDividerLocation());
        if (this.attachments.isVisible()) {
            this.attDividerLocation = this.attchmntSplit.getDividerLocation();
        }
        options.setAttachmentSplit(this.attDividerLocation);
        options.setColumnWidths(this.getColumnWidths());
        this.saveSelectedMessage();
    }

    private void restoreColumnWidths() {
        String columnWidths = Options.getInstance().getColumnWidths();
        String[] columns = columnWidths.split(";");
        TableColumnModel columnModel = this.messagesTable.getColumnModel();
        if (columnModel.getColumnCount() != columns.length) {
            Log.error("Number of columns count (" + columnModel.getColumnCount() + ") is not equal with saved in persistence " + columns.length);
        } else {
            int i = 0;
            for (String column : columns) {
                int intValue = Integer.parseInt(column);
                columnModel.getColumn(i).setPreferredWidth(intValue);
                ++i;
            }
        }
    }

    private String getColumnWidths() {
        TableColumnModel columnModel = this.messagesTable.getColumnModel();
        String columnWidths = "";
        String delimeter = "";
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnWidths = columnWidths + delimeter + columnModel.getColumn(i).getWidth();
            if (!delimeter.equals("")) continue;
            delimeter = ";";
        }
        return columnWidths;
    }

    private void initPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.tableModel = new MessageTableModel();
        this.messagesTable = new JTable(this.tableModel);
        ListSelectionModel listSelectionModel = this.messagesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DirectoryViewer.this.updateMessage();
                }
            }

            private void printIndex(String idName, int index) {
                System.out.println(idName + " " + index + " msg from: " + DirectoryViewer.this.tableModel.getValueAt(index, 0) + " msg to:" + DirectoryViewer.this.tableModel.getValueAt(index, 1));
            }
        });
        String ENTER_ACTION_KEY = "myEnterAction";
        this.messagesTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "myEnterAction");
        this.messagesTable.getActionMap().put("myEnterAction", Actions.openMessage);
        this.messagesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DirectoryViewer.this.checkPopup(e);
                if (e.getClickCount() == 2) {
                    Actions.openMessage.actionPerformed(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DirectoryViewer.this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DirectoryViewer.this.checkPopup(e);
            }
        });
        this.messagesTable.getTableHeader().setReorderingAllowed(false);
        this.messagesTable.getSelectionModel();
        JScrollPane tableScrollPane = new JScrollPane(this.messagesTable);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        this.messageHeader = new MessageHeaderPanel();
        this.messageText = new JTextPane();
        this.messageText.setEditable(false);
        this.messageText.setText("");
        messagePanel.add((Component)this.messageHeader, "North");
        messagePanel.add((Component)new JScrollPane(this.messageText), "Center");
        this.attchmntSplit = new JSplitPane(1, messagePanel, this.getAttachmentsPanel());
        this.attDividerLocation = Options.getInstance().getAttachmentsSplit();
        this.attchmntSplit.setDividerLocation(this.attDividerLocation);
        this.splitPane = new JSplitPane(0, tableScrollPane, this.attchmntSplit);
        this.splitPane.setDividerLocation(Options.getInstance().getHorizontallSplit());
        this.panel.add((Component)this.splitPane, "Center");
        this.restoreColumnWidths();
        this.hideAttachments();
    }

    private Component getAttachmentsPanel() {
        this.attachmentList = new AttachmentList(false);
        this.attachments = this.attachmentList.getRepresentation();
        return this.attachments;
    }

    private void checkPopup(MouseEvent e) {
        int lastRowUnderMouse = this.messagesTable.rowAtPoint(e.getPoint());
        if (e.isPopupTrigger()) {
            if (lastRowUnderMouse != -1 && !this.isRowSelected(lastRowUnderMouse)) {
                this.selectMessageRow(lastRowUnderMouse);
            }
            MessagePopup.show(this.messagesTable, e.getPoint());
        }
    }

    private void showAttachments() {
        this.attchmntSplit.setDividerLocation(this.attDividerLocation);
        this.attachments.setVisible(true);
    }

    private void hideAttachments() {
        if (this.attachments.isVisible()) {
            this.attDividerLocation = this.attchmntSplit.getDividerLocation();
            this.attchmntSplit.setDividerLocation(this.attchmntSplit.getMaximumDividerLocation());
            this.attachments.setVisible(false);
        }
    }

    private int getSelectedRow() {
        return this.messagesTable.getSelectionModel().getLeadSelectionIndex();
    }

    private void updateMessage() {
        MessageRecord msg = this.getSelectedMessage();
        if (msg == null) {
            this.messageHeader.setEmpty();
            this.messageText.setText("");
            Actions.replyToMessage.setEnabled(false);
            this.hideAttachments();
        } else {
            this.messageHeader.updateHeader(msg);
            this.messageText.setText(msg.getMessageText());
            Actions.setMessageIsSelected(true);
            List<AttachmentRef> attachments = msg.getAttachmentsInfo();
            System.out.println("attch size = " + attachments.size());
            this.attachmentList.setFiles(attachments);
            if (attachments.size() > 0) {
                this.showAttachments();
            } else {
                this.hideAttachments();
            }
        }
    }

    public MessageRecord getSelectedMessage() {
        int selectedRowNumber = this.getSelectedRow();
        if (selectedRowNumber == -1 && !this.isRowSelected(selectedRowNumber)) {
            return null;
        }
        return this.tableModel.getMessage(selectedRowNumber);
    }

    public boolean isRowSelected(int index) {
        return this.messagesTable.getSelectionModel().isSelectedIndex(index);
    }

    public void update(Directory directory) {
        if (this.previousDirectory != null) {
            this.saveSelectedMessage();
        }
        this.tableModel.setDirectory(directory);
        MessageRecord messageRecord = directory.getSelectedMessage();
        if (messageRecord != null) {
            this.selectMessage(messageRecord);
        }
        this.previousDirectory = directory;
    }

    public void saveSelectedMessage() {
        this.saveSelectedMessage(this.previousDirectory);
    }

    private void saveSelectedMessage(Directory previousDirectory) {
        if (previousDirectory != null) {
            MessageRecord selectedMessage = this.getSelectedMessage();
            previousDirectory.setSelectedMessage(selectedMessage);
        }
    }

    private void selectMessage(MessageRecord messageRecord) {
        int index = this.tableModel.getIndex(messageRecord);
        if (index > -1) {
            this.selectMessageRow(index);
        }
    }

    private void selectMessageRow(int index) {
        this.messagesTable.setRowSelectionInterval(index, index);
    }

    public boolean isMessageSelected() {
        return this.messagesTable.getSelectedRow() != -1;
    }

    public MessageRecord deleteSelectedMessage() {
        int selectedRowNumber = this.messagesTable.getSelectedRow();
        MessageRecord messageRecord = null;
        if (selectedRowNumber != -1) {
            messageRecord = this.tableModel.getMessage(selectedRowNumber);
            this.tableModel.deleteMessageAt(selectedRowNumber);
            if (selectedRowNumber < this.tableModel.getRowCount()) {
                this.selectMessageRow(selectedRowNumber);
            } else if (this.tableModel.getRowCount() > 0) {
                this.selectMessageRow(this.tableModel.getRowCount() - 1);
            }
        }
        return messageRecord;
    }

    public Set<MessageRecord> deleteSelectedMessages() {
        int[] selectedRows = this.messagesTable.getSelectedRows();
        Set<MessageRecord> deletedMessages = new HashSet<MessageRecord>();
        if (selectedRows.length > 0) {
            MessageRecord messageToBeSelected = null;
            if (this.getSelectedRow() != -1) {
                messageToBeSelected = this.getFirstUnselectedMessage(this.getSelectedRow());
            }
            deletedMessages = this.tableModel.deleteMessages(selectedRows);
            if (messageToBeSelected != null) {
                this.selectMessage(messageToBeSelected);
            } else if (this.tableModel.getRowCount() > 0) {
                this.selectMessageRow(this.tableModel.getRowCount() - 1);
            }
        }
        return deletedMessages;
    }

    private MessageRecord getFirstUnselectedMessage(int lastSelectedRow) {
        for (int nextSelectionIndex = lastSelectedRow; nextSelectionIndex < this.tableModel.getRowCount(); ++nextSelectionIndex) {
            if (this.isRowSelected(nextSelectionIndex)) continue;
            return this.tableModel.getMessage(nextSelectionIndex);
        }
        return null;
    }
}

