/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol;

import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.impl.AbstractProtocol;
import com.jslope.io.protocol.impl.RootProtocol;
import com.jslope.io.protocol.impl.protocols.CheckDomainProtocol;
import com.jslope.io.protocol.impl.protocols.CheckIDOnServerProtocol;
import com.jslope.io.protocol.impl.protocols.CheckIDPermitProtocol;
import com.jslope.io.protocol.impl.protocols.DNSProtocol;
import com.jslope.io.protocol.impl.protocols.InstallDomainProtocol;
import com.jslope.io.protocol.impl.protocols.InstallIDPermitProtocol;
import com.jslope.io.protocol.impl.protocols.InstallIDonServerProtocol;
import com.jslope.io.protocol.impl.protocols.ListenClientToServerProtocol;
import com.jslope.io.protocol.impl.protocols.ListenToServerProtocol;
import com.jslope.io.protocol.impl.protocols.ReceiveIDProtocol;
import com.jslope.io.protocol.impl.protocols.ReceiveMessagesProtocol;
import com.jslope.io.protocol.impl.protocols.RemoveAccountFromServerProtocol;
import com.jslope.io.protocol.impl.protocols.RemoveDomainProtocol;
import com.jslope.io.protocol.impl.protocols.RemoveIDPermitProtocol;
import com.jslope.io.protocol.impl.protocols.SendIDForSigning;
import com.jslope.io.protocol.impl.protocols.SendMessagesProtocol;
import com.jslope.io.protocol.impl.protocols.Server2ServerMessagesProtocol;
import com.jslope.io.protocol.impl.protocols.SignIDOnServerProtocol;
import com.jslope.io.protocol.impl.protocols.UpdateDNSProtocol;
import com.jslope.security.Domain;

public class Protocols {
    private static Protocol instantiateProtocol(Class<? extends AbstractProtocol> aClass) {
        try {
            AbstractProtocol protocol = aClass.newInstance();
            protocol.setProtocolStack();
            return protocol;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to instantiate class " + aClass, e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to instantiate class " + aClass, e);
        }
    }

    public static AbstractProtocol getRootProtocolnew() {
        return new RootProtocol();
    }

    public static Protocol getInstallDomainProtocol(String serverIDName, Domain domain) {
        Protocol protocol = Protocols.instantiateProtocol(InstallDomainProtocol.class);
        protocol.setValue(ProtocolConstants.DOMAIN, domain);
        protocol.setValue(ProtocolConstants.SERVER_ID_NAME, serverIDName);
        return protocol;
    }

    public static Protocol getUpdateDNSProtocol(Domain domain, Address newDomainAddress, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.instantiateProtocol(UpdateDNSProtocol.class);
        protocol.setValue(ProtocolConstants.DOMAIN, domain);
        protocol.setValue(ProtocolConstants.DOMAIN_NAME_TO_CONNECT, domain.getParent().getName());
        protocol.setValue(ProtocolConstants.NEW_DOMAIN_ADDRESS, newDomainAddress);
        protocol.setErrorHandler(errorHandler);
        return protocol;
    }

    public static Protocol getDNSProtocol(String domainName, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.instantiateProtocol(DNSProtocol.class);
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_NAME, domainName);
        return protocol;
    }

    public static Protocol getCheckDomainProtocol() {
        return Protocols.instantiateProtocol(CheckDomainProtocol.class);
    }

    public static Protocol getRemoveDomainProtocol() {
        return Protocols.instantiateProtocol(RemoveDomainProtocol.class);
    }

    public static Protocol getInstallIDPermitProtocol() {
        return Protocols.instantiateProtocol(InstallIDPermitProtocol.class);
    }

    public static Protocol getIsIDPermitProtocol() {
        return Protocols.instantiateProtocol(CheckIDPermitProtocol.class);
    }

    public static Protocol getRemoveIDPermitProtocol() {
        return Protocols.instantiateProtocol(RemoveIDPermitProtocol.class);
    }

    public static Protocol getSendIDForSigningProtocol() {
        return Protocols.instantiateProtocol(SendIDForSigning.class);
    }

    public static Protocol getSignIDOnServerProtocol() {
        return Protocols.instantiateProtocol(SignIDOnServerProtocol.class);
    }

    public static Protocol getIsIDOnServerProtocol() {
        return Protocols.instantiateProtocol(CheckIDOnServerProtocol.class);
    }

    public static Protocol getRemoveAccountFromServerProtocol() {
        return Protocols.instantiateProtocol(RemoveAccountFromServerProtocol.class);
    }

    public static Protocol getInstallIDOnServer() {
        return Protocols.instantiateProtocol(InstallIDonServerProtocol.class);
    }

    public static Protocol getReceiveIDPorotocol() {
        return Protocols.instantiateProtocol(ReceiveIDProtocol.class);
    }

    public static Protocol getSendMessagesProtocol() {
        return Protocols.instantiateProtocol(SendMessagesProtocol.class);
    }

    public static Protocol getReceiveMessagesProtocol() {
        return Protocols.instantiateProtocol(ReceiveMessagesProtocol.class);
    }

    public static Protocol getSendMessagesServer2ServerProtocol() {
        return Protocols.instantiateProtocol(Server2ServerMessagesProtocol.class);
    }

    public static Protocol getListenToServer() {
        return Protocols.instantiateProtocol(ListenToServerProtocol.class);
    }

    public static Protocol getListenClientToServer() {
        return Protocols.instantiateProtocol(ListenClientToServerProtocol.class);
    }
}

