/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.DataTransport;
import com.jslope.io.stream.impl.AdvancedIODataInputStream;
import com.jslope.io.stream.impl.AdvancedIODataOutputStream;
import com.jslope.security.PublicID;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;
import java.net.Socket;

public class IODataTransport
implements DataTransport {
    AdvancedDataOutput out;
    AdvancedDataInput in;
    Socket socket;

    public IODataTransport(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new AdvancedIODataOutputStream(socket.getOutputStream());
        this.in = new AdvancedIODataInputStream(socket.getInputStream());
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.in.readBytes();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }

    @Override
    public void writeLong(long longValue) throws IOException {
        this.out.writeLong(longValue);
    }

    @Override
    public void writeBytes(byte[] encoded) throws IOException {
        this.out.writeBytes(encoded);
    }

    @Override
    public void writeBoolean(boolean booleanValue) throws IOException {
        this.out.writeBoolean(booleanValue);
    }

    @Override
    public void writeByte(byte byteValue) throws IOException {
        this.out.writeByte(byteValue);
    }

    @Override
    public void writeByte(int byteValue) throws IOException {
        this.out.writeByte(byteValue);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.out.writeInt(value);
    }

    @Override
    public void writePublicID(PublicID publicID) throws IOException {
        publicID.serialize(this.out);
    }

    @Override
    public PublicID readPublicID() throws IOException {
        return IDFactory.deserializePublicID(this.in);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

