/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;

public class CheckIDAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        tr.writePublicID(serverHandler.getServerID().getPublicPart());
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        PublicID serverID = tr.readPublicID();
        this.verifyServerID(parentProtocol, serverID);
        parentProtocol.setValue(ProtocolConstants.SERVER_ID, serverID);
    }

    private void verifyServerID(ClientProtocol parentProtocol, PublicID serverID) throws ActionException {
        String formServerIDName = (String)parentProtocol.getValue(ProtocolConstants.SERVER_ID_NAME);
        if (serverID.getName().equals(formServerIDName)) {
            try {
                serverID.verifyInternalSignature();
            }
            catch (CryptogException e) {
                e.printStackTrace();
                parentProtocol.addError("Validation of server id failed", "Validation of id " + serverID + " failed", e);
                throw new ActionException("Validation of server id failed", e);
            }
        } else {
            parentProtocol.addError("Server id doesn't match", "Server id " + serverID.getName() + " doesn't match with requested id " + formServerIDName);
            throw new ActionException("Server id " + serverID.getName() + " doesn't match with requested id " + formServerIDName);
        }
        System.out.println(" received serverID = " + serverID);
    }
}

