/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.TransportFactory;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.IDSignedByDomain;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.JSlopeSymetricKey;
import com.jslope.security.crypto.SymetricKeyFactory;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.SignFactory;
import java.io.IOException;

public class ConnectToDomainAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        try {
            DataTransport tr = parentProtocol.getTransport();
            SecureID serverID = parentProtocol.getServerHandler().getServerID();
            tr.writePublicID(serverID.getPublicPart());
            byte[] encryptedKey = tr.readBytes();
            byte[] decryptedKey = serverID.decryptLowLevelBytes(encryptedKey);
            JSlopeSymetricKey simmetrycKey = SymetricKeyFactory.createKey(decryptedKey);
            tr = TransportFactory.generate(tr, simmetrycKey);
            parentProtocol.setTransport(tr);
            String domainName = tr.readUTF();
            IDSignedByDomain signedID = parentProtocol.getServerHandler().getIDSignedByDomain(domainName);
            if (signedID == null) {
                tr.writeByte((byte)3);
                throw new ActionException("Domain " + domainName + " not installed on this server");
            }
            parentProtocol.setValue(ProtocolConstants.PUBLIC_DOMAIN_TO_VERIFY, signedID.getDomain());
            tr.writeByte((byte)1);
            signedID.serialize(tr);
        }
        catch (CryptogException e) {
            e.printStackTrace();
            throw new ActionException("Cryptographic exception", e);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        try {
            DataTransport tr = parentProtocol.getTransport();
            PublicID serverPublicID = tr.readPublicID();
            if (!serverPublicID.verifyInternalSignature()) {
                Log.error("verifying internal signature of server ID failed");
                parentProtocol.addError("verification of internal signature of server ID failed", "verification of Interal signature of server id failed: " + serverPublicID.getName());
            }
            JSlopeSymetricKey simmetrycKey = SymetricKeyFactory.generateKey();
            byte[] encryptedKey = serverPublicID.encryptLowLevelBytes(simmetrycKey.getBytes());
            tr.writeBytes(encryptedKey);
            tr = TransportFactory.generate(tr, simmetrycKey);
            parentProtocol.setTransport(tr);
            String domainName = (String)parentProtocol.getValue(ProtocolConstants.DOMAIN_NAME_TO_CONNECT);
            if (domainName == null) {
                parentProtocol.throwActionException("null exception", "ProtocolConstants.DOMAIN_NAME_TO_CONNECT == null");
            }
            tr.writeUTF(domainName);
            byte returnCode = tr.readByte();
            switch (returnCode) {
                case 1: {
                    IDSignedByDomain signedID = SignFactory.deserializeIDSignedByDomain(tr);
                    if (!signedID.verifySignature()) {
                        throw new CryptogException("Verification of server id signed by domainName: " + domainName + " failed");
                    }
                    if (!signedID.getSignedID().isEqual(serverPublicID)) {
                        parentProtocol.throwActionException("serverID error", "Supplied serverID is not the same as ID signed by domainName");
                    }
                    break;
                }
                case 3: {
                    throw new ActionException("Domain " + domainName + " is not installed on server");
                }
                default: {
                    throw new ActionException("Unkown error occurred, return code is: " + returnCode);
                }
            }
        }
        catch (CryptogException e) {
            e.printStackTrace();
            throw new ActionException("Cryptographic Exception", e);
        }
    }
}

