/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.AddressSignedByDomain;
import com.jslope.security.impl.JSLopeAddressSignedByDomain;
import java.io.IOException;

public class GetDomainAddressAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        String domainName = tr.readUTF();
        AddressSignedByDomain address = null;
        address = serverHandler.getDomainAddress(domainName);
        if (address != null) {
            System.out.println("requested address for " + domainName + " is: " + address.getAddress());
            tr.writeByte((byte)1);
            address.serialize(tr);
        } else {
            tr.writeByte((byte)4);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        String domainName = (String)parentProtocol.getValue(ProtocolConstants.DOMAIN_NAME);
        tr.writeUTF(domainName);
        if (tr.readByte() != 1) {
            parentProtocol.addError("Domain not found on server", "Domain " + domainName + " not found on server");
            throw new ActionException("Domain " + domainName + " not found on server");
        }
        JSLopeAddressSignedByDomain address = new JSLopeAddressSignedByDomain();
        address.deserialize(tr);
        parentProtocol.setValue(ProtocolConstants.ADDRESS, address);
    }
}

