/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.Domain;
import com.jslope.security.IDSignedByDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.SignFactory;
import java.io.IOException;

public class InstallDomainAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        IDSignedByDomain signedID = SignFactory.deserializeIDSignedByDomain(tr);
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        PublicID serverID = serverHandler.getServerID().getPublicPart();
        if (serverID.isEqual(signedID.getSignedID())) {
            try {
                if (signedID.verifySignature()) {
                    if (serverHandler.domainExists(signedID.getDomain())) {
                        tr.writeByte((byte)5);
                    }
                    serverHandler.installDomain(signedID);
                    tr.writeByte((byte)1);
                }
                tr.writeByte((byte)6);
            }
            catch (CryptogException e) {
                tr.writeByte((byte)6);
                e.printStackTrace();
                parentProtocol.addError("Verification failed", "Verification failed for received signed id", e);
                throw new ActionException("Verification failed for received signed object", e);
            }
        } else {
            String error = "Local public id " + serverID + " is NOT equal with received one " + signedID.getSignedID();
            parentProtocol.addError("IDs don't match", error);
            throw new ActionException(error);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN);
        PublicID serverID = (PublicID)parentProtocol.getValue(ProtocolConstants.SERVER_ID);
        assert (domain != null);
        assert (serverID != null);
        IDSignedByDomain signedServerID = null;
        try {
            signedServerID = SignFactory.signObject(serverID, domain);
        }
        catch (CryptogException e) {
            e.printStackTrace();
            parentProtocol.addError(e);
            throw new ActionException("Exception while signing", e);
        }
        signedServerID.serialize(tr);
        byte switchByte = tr.readByte();
        switch (switchByte) {
            case 1: {
                return;
            }
            case 5: {
                parentProtocol.addError("Domain already exists on server", "Domain " + domain.getName() + " already exists on server");
                break;
            }
            case 6: {
                parentProtocol.addError("Server reported crypto error", "Server reported cryptographic error");
                break;
            }
            default: {
                parentProtocol.addError("Bad switch value", "Bad switch value: " + switchByte);
            }
        }
    }
}

