/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.messages.StringMessage;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.DomainFactory;
import java.io.IOException;

public class RemoveDomainAction
implements ProtocolAction {
    private static final String REMOVE = "remove";

    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        DataTransport tr = parentProtocol.getTransport();
        PublicDomain publicDomain = DomainFactory.deserializePublicDomain(tr);
        StringMessage message = new StringMessage();
        message.deserialize(tr);
        byte[] signature = tr.readBytes();
        byte retValue = 2;
        PublicDomain domainOnServer = serverHandler.getIDSignedByDomain(publicDomain.getName()).getDomain();
        if (publicDomain.verifyInternalSignature() && publicDomain.verifySignature(message, signature) && message.getString().equals(REMOVE) && (domainOnServer.isEqual(publicDomain) || publicDomain.getSignTime() > domainOnServer.getSignTime()) && serverHandler.removeDomain(publicDomain)) {
            retValue = 1;
        }
        tr.writeByte(retValue);
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN);
        StringMessage message = new StringMessage(REMOVE);
        byte[] signature = domain.sign(message);
        domain.getPublicPart().serialize(tr);
        message.serialize(tr);
        tr.writeBytes(signature);
        Boolean retVal = tr.readByte() == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

