/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.messages.MailMessage;
import com.jslope.io.protocol.messages.MessageFactory;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;
import java.util.List;

public class SendMessagesAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        int howManyMessages = tr.readInt();
        for (int i = 0; i < howManyMessages; ++i) {
            MailMessage message = MessageFactory.deserializeMailMessage(tr);
            message.verifySignature();
            serverHandler.dispatchMessage(message);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        List messages = (List)parentProtocol.getValue(ProtocolConstants.MAIL_MESSAGES);
        tr.writeInt(messages.size());
        for (MailMessage message : messages) {
            message.serialize(tr);
        }
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, true);
    }
}

