/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;

public class SendStringAction
implements ProtocolAction {
    private ProtocolConstants stringNameToSend;

    public SendStringAction(ProtocolConstants stringName) {
        this.stringNameToSend = stringName;
    }

    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        String receivedString = tr.readUTF();
        parentProtocol.setValue(this.stringNameToSend, receivedString);
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        String stringToSend = (String)parentProtocol.getValue(this.stringNameToSend);
        tr.writeUTF(stringToSend);
    }
}

