/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.Config;
import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.IDSignedByDomain;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import com.jslope.security.impl.SignFactory;
import java.io.IOException;

public class VerifyServerIDAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        IDSignedByDomain signedID = SignFactory.deserializeIDSignedByDomain(tr);
        byte[] randomBytes = JSlopeRandom.getRandom(1024);
        tr.writeBytes(randomBytes);
        byte[] signature = tr.readBytes();
        boolean signatureIsOk = signedID.getSignedID().verifySignature(randomBytes, signature);
        if (signatureIsOk && signedID.verifySignature()) {
            tr.writeByte((byte)1);
            System.out.println("Storing verified domain: " + signedID.getDomain().getName());
            parentProtocol.storeVerifiedDomain(signedID.getDomain());
        } else {
            tr.writeByte((byte)12);
            parentProtocol.throwActionException("Bad signature", "Bad signature on client side for " + signedID);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        SecureID serverID = Config.getServerHandler().getServerID();
        IDSignedByDomain idSigndedByDomain = (IDSignedByDomain)parentProtocol.getValue(ProtocolConstants.ID_SIGNED_BY_DOMAIN);
        idSigndedByDomain.serialize(tr);
        byte[] bytesToSign = tr.readBytes();
        byte[] signature = serverID.signLowLevelBytes(bytesToSign);
        tr.writeBytes(signature);
        byte retValue = tr.readByte();
        if (retValue != 1) {
            parentProtocol.throwActionException("Bad signature", "Bad signature on client side");
        }
    }
}

