/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence;

import com.jslope.persistence.DBPersistentObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ObjectCache {
    private static ObjectCache ourInstance = new ObjectCache();
    private Map<String, DBPersistentObject> cache = new HashMap<String, DBPersistentObject>();
    private int MAX_SIZE = 0;
    private Vector<String> queue = new Vector();

    public static ObjectCache getInstance() {
        return ourInstance;
    }

    private ObjectCache() {
    }

    public boolean hasObject(String objectID) {
        return this.cache.containsKey(objectID);
    }

    public DBPersistentObject get(String objectID) {
        return this.cache.get(objectID);
    }

    public synchronized void add(DBPersistentObject object) {
        String id = object.getID();
        if (this.hasObject(id)) {
            System.out.println("adding an object which already exists: " + object + " id:" + id);
        }
        this.cache.put(id, object);
        this.queue.add(id);
        if (this.queue.size() > this.MAX_SIZE && this.MAX_SIZE != 0) {
            this.removeOldestElement();
        }
    }

    private void removeOldestElement() {
        String id = this.queue.get(0);
        this.queue.remove(0);
        this.cache.remove(id);
    }

    public void remove(DBPersistentObject dbPersistentObject) {
        this.queue.remove(dbPersistentObject.getID());
        this.cache.remove(dbPersistentObject.getID());
    }

    public void clearCache() {
        this.queue.clear();
        this.cache.clear();
    }
}

