/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.fields;

import com.jslope.persistence.fields.Field;
import com.jslope.persistence.sql.SqlUtil;
import com.jslope.utils.Log;

public class BooleanField
extends Field {
    protected boolean defaultValue = true;

    public BooleanField() {
        this.setValue("0");
    }

    public BooleanField(String value) {
        this.setValue(value);
    }

    public BooleanField(boolean value) {
        this.setDefaultValue(BooleanField.booleanValue(value));
    }

    @Override
    public String getSQLType() {
        return SqlUtil.getSqlServer().getTypeForBoolean();
    }

    @Override
    public void setValue(String value) {
        value = BooleanField.validateBoolean(value);
        super.setValue(value);
    }

    private static String validateBoolean(String value) {
        if (value.equals("false")) {
            value = "0";
        }
        if (value.equals("true")) {
            value = "1";
        }
        if (!value.equals("0") && !value.equals("1")) {
            Log.error(" bad value for BooleanField " + value);
            value = "0";
        }
        return value;
    }

    public static String booleanValue(boolean booleanValue) {
        return BooleanField.validateBoolean(String.valueOf(booleanValue));
    }

    public void setValue(boolean value) {
        this.setValue(BooleanField.booleanValue(value));
    }

    public boolean getBooleanValue() {
        boolean retValue = !this.getValue().equals("0");
        return retValue;
    }
}

