/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.sql;

import com.jslope.persistence.Config;
import com.jslope.persistence.DBConnection;
import com.jslope.persistence.PersistenceException;
import com.jslope.persistence.sql.BasicCondition;
import com.jslope.persistence.sql.Limit;
import com.jslope.persistence.sql.QueryException;
import com.jslope.persistence.sql.ResultIterator;
import com.jslope.persistence.sql.ResultRow;
import com.jslope.persistence.sql.SqlServer;
import com.jslope.persistence.sql.impl.ResultIteratorImplimentation;
import com.jslope.persistence.utils.Pair;
import com.jslope.utils.Log;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultSqlServer
implements SqlServer {
    protected String dateFormat = "yyyy-MM-dd";
    String types = Config.getTypesTableName();
    String fields = Config.getFieldsTableName();
    static Map<String, String> convertionCharset = new HashMap<String, String>();
    static Map<String, String> encodingMap = new HashMap<String, String>();
    static Map<Character, Character> decodingMap = new HashMap<Character, Character>();
    static final String[] target = new String[]{"+", "'", "\""};
    static final String[] replace = new String[]{"+", "q", "d"};

    @Override
    public ResultIterator findAll(String tableName) throws QueryException {
        return this.findByAnd(tableName, null, null);
    }

    @Override
    public ResultIterator findByAnd(String tableName, String[] fields, Pair[] where, String[] orderBy) throws QueryException {
        String query = this.createPreparedSelect(fields, tableName, where, orderBy);
        return this.executePreparedQuery(query, fields, Pair.getValues(where));
    }

    @Override
    public ResultIterator findByAnd(String tableName, String[] fields, Pair[] where) throws QueryException {
        return this.findByAnd(tableName, fields, where, null);
    }

    @Override
    public ResultIterator find(String tableName, String[] fields, BasicCondition cond, String[] orderBy) throws QueryException {
        return this.find(tableName, fields, cond, orderBy, null);
    }

    @Override
    public ResultIterator find(String tableName, String[] fields, BasicCondition cond, String[] orderBy, Limit limit) throws QueryException {
        String query = this.createPreparedSelect(fields, tableName, cond, orderBy, limit);
        List<String> values = cond != null ? cond.prepareValues() : new Vector<String>();
        return this.executePreparedQuery(query, fields, values);
    }

    @Override
    public void createTable(String tableName) {
        String sql = "CREATE TABLE " + this.formatTableName(tableName) + "( isDeleted varchar(1) NOT NULL default '')";
        DefaultSqlServer.executeUpdate(sql);
    }

    @Override
    public void dropTable(String tableName) {
        String sql = "DROP TABLE " + this.formatTableName(tableName);
        DefaultSqlServer.executeUpdate(sql);
    }

    @Override
    public void addField(String tableName, String fieldName, String fieldType) {
        String sql = "ALTER TABLE " + this.formatTableName(tableName) + " ADD (" + this.formatField(fieldName) + " " + fieldType + ")";
        DefaultSqlServer.executeUpdate(sql);
    }

    @Override
    public void removeField(String tableName, String fieldName) {
        String sql = "ALTER TABLE " + this.formatTableName(tableName) + " DROP COLUMN " + this.formatField(fieldName);
        DefaultSqlServer.executeUpdate(sql);
    }

    @Override
    public void changeFieldName(String tableName, String oldFieldName, String newFieldName, String fieldType) {
        this.addField(tableName, newFieldName, fieldType);
        String sql = "UPDATE " + this.formatTableName(tableName) + " SET " + newFieldName + " = " + oldFieldName;
        DefaultSqlServer.executeUpdate(sql);
        this.removeField(tableName, oldFieldName);
    }

    @Override
    public void updateField(String tableName, String fieldName, String fieldType, String newType) {
        String tempName = "qwertyuiopasdfghjjklzxcvbnnm";
        this.addField(tableName, tempName, newType);
        String sql = "UPDATE " + this.formatTableName(tableName) + " SET " + tempName + " = " + fieldName;
        DefaultSqlServer.executeUpdate(sql);
        this.removeField(tableName, fieldName);
        this.changeFieldName(tableName, tempName, fieldName, newType);
    }

    @Override
    public boolean insert(String tableName, Pair[] fields) {
        StringBuffer sb = new StringBuffer("INSERT INTO ").append(this.formatTableName(tableName)).append(" (");
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            Pair field = fields[i];
            sb.append(this.formatField((String)field.getFirst()));
            Object value = field.getSecond();
            values.append("?");
            if (i >= fields.length - 1) continue;
            sb.append(", ");
            values.append(", ");
        }
        sb.append(") VALUES ( ");
        sb.append(values.toString());
        sb.append(")");
        return DefaultSqlServer.executePreparedUpdate(sb.toString(), fields);
    }

    @Override
    public void delete(String tableName, Pair[] conditionFields) {
        StringBuffer sb = new StringBuffer("DELETE FROM ").append(this.formatTableName(tableName));
        this.append(sb, "WHERE ", conditionFields, " AND ");
        DefaultSqlServer.executeUpdate(sb.toString());
    }

    @Override
    public void deleteAll(String tableName) {
        DefaultSqlServer.executeUpdate("DELETE FROM " + this.formatTableName(tableName));
    }

    @Override
    public void delete(String tableName, BasicCondition conditionFields) {
        StringBuffer sb = new StringBuffer("DELETE FROM ").append(this.formatTableName(tableName));
        sb.append(" WHERE ").append(conditionFields.preparedString());
        List<String> values = conditionFields != null ? conditionFields.prepareValues() : new Vector<String>();
        this.executePreparedUpdate(sb.toString(), values);
    }

    @Override
    public void update(String tableName, Pair[] setFields, Pair[] conditionFields) {
        StringBuffer sb = new StringBuffer("UPDATE ").append(this.formatTableName(tableName));
        this.preparedAppend(sb, "SET ", setFields, ", ");
        if (conditionFields != null) {
            Pair pair;
            int i$;
            this.preparedAppend(sb, "WHERE ", conditionFields, " AND ");
            Pair[] fields = new Pair[setFields.length + conditionFields.length];
            int i = 0;
            Pair[] arr$ = setFields;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                fields[i] = pair = arr$[i$];
                ++i;
            }
            arr$ = conditionFields;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                fields[i] = pair = arr$[i$];
                ++i;
            }
            DefaultSqlServer.executePreparedUpdate(sb.toString(), fields);
        } else {
            DefaultSqlServer.executePreparedUpdate(sb.toString(), setFields);
        }
    }

    public static boolean executeUpdate(String sql) {
        try {
            Statement st = DBConnection.getConnection().createStatement();
            st.executeUpdate(sql);
            st.close();
            return true;
        }
        catch (SQLException e) {
            System.out.println("ERROR during execution of " + sql);
            e.printStackTrace();
            throw new PersistenceException("ERROR during execution of " + sql + " exception:" + e.getMessage());
        }
    }

    public static boolean executePreparedUpdate(String sql, Pair[] fields) {
        try {
            PreparedStatement st = DBConnection.getConnection().prepareStatement(sql);
            int i = 1;
            for (Pair field : fields) {
                Object value = field.getSecond();
                if (value instanceof Blob) {
                    st.setBlob(i, (Blob)value);
                } else {
                    st.setObject(i, field.getSecond());
                }
                ++i;
            }
            st.executeUpdate();
            st.close();
            return true;
        }
        catch (SQLException e) {
            System.out.println("ERROR during execution of " + sql);
            e.printStackTrace();
            throw new PersistenceException("ERROR during execution of " + sql + " exception:" + e.getMessage());
        }
    }

    @Override
    public String getTypeForDate() {
        return "DATE";
    }

    @Override
    public Date parseDate(String stringDate) {
        if (stringDate == null || "null".equals(stringDate)) {
            return new Date();
        }
        try {
            return new SimpleDateFormat(this.dateFormat).parse(stringDate);
        }
        catch (ParseException e) {
            Log.error("was unable to parse Date " + stringDate, e);
            return new Date();
        }
    }

    @Override
    public String dateToString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
        return formatter.format(date);
    }

    @Override
    public String getTypeForString(int size) {
        return "VARCHAR(" + size + ")";
    }

    @Override
    public String getTypeForText() {
        return "VARCHAR";
    }

    @Override
    public String getTypeForBlob() {
        return "BLOB";
    }

    @Override
    public String getTypeForBoolean() {
        return this.getTypeForString(1);
    }

    @Override
    public String getTypeForInt() {
        return "INT";
    }

    @Override
    public String getTypeForLong() {
        return "BIGINT";
    }

    @Override
    public String getTypeForAutoincrementInt() {
        return "INT IDENTITY";
    }

    @Override
    public String getTypeForNumber(int decimalSize, int floatSize) {
        return "FIXED(" + decimalSize + ", " + floatSize + ")";
    }

    @Override
    public String formatValue(String fieldName) {
        return this.surround(fieldName, '\"');
    }

    @Override
    public String formatField(String fieldName) {
        return this.surround(fieldName, '\"');
    }

    public String formatTableName(String tableName) {
        return this.surround(tableName, '\"');
    }

    protected String formatFieldEquals(String fieldName, Object value) {
        StringBuffer sb = new StringBuffer();
        if (value == null) {
            value = "null";
        }
        sb.append(this.formatField(fieldName));
        sb.append("=");
        if (value instanceof Integer) {
            sb.append(value.toString());
        } else {
            sb.append(this.formatValue(value.toString()));
        }
        return sb.toString();
    }

    protected String formatPreparedFieldEquals(String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.formatField(fieldName));
        sb.append("= ?");
        return sb.toString();
    }

    protected String surround(String s, char surroundChar) {
        StringBuffer sb = new StringBuffer();
        sb.append(surroundChar).append(s).append(surroundChar);
        return sb.toString();
    }

    protected ResultSet executePreparedQuery(String query, List<String> values) throws SQLException {
        PreparedStatement st = null;
        st = DBConnection.getConnection().prepareStatement(query);
        int j = 1;
        for (String val : values) {
            st.setString(j, val);
            ++j;
        }
        return st.executeQuery();
    }

    protected int executePreparedUpdate(String query, List<String> values) {
        PreparedStatement st = null;
        try {
            st = DBConnection.getConnection().prepareStatement(query);
            int j = 1;
            for (String val : values) {
                st.setString(j, val);
                ++j;
            }
            return st.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PersistenceException("ERROR during execution of " + query + " exception:" + e.getMessage());
        }
    }

    protected ResultSet safelyExecuteQuery(String query, List<String> values) throws SQLException {
        return this.executePreparedQuery(query, values);
    }

    private ResultIterator executePreparedQuery(String query, String[] fields, List<String> values) throws QueryException {
        ArrayList<ResultRow> rows = new ArrayList<ResultRow>();
        ResultSet rset = null;
        Statement st = null;
        try {
            rset = this.safelyExecuteQuery(query, values);
            st = rset.getStatement();
            ResultSetMetaData metaData = rset.getMetaData();
            while (rset.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                block13: for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    int columnIndex = rset.findColumn(field);
                    switch (metaData.getColumnType(columnIndex)) {
                        case -4: 
                        case 2004: {
                            map.put(field, rset.getBlob(columnIndex));
                            continue block13;
                        }
                        default: {
                            map.put(field, rset.getObject(columnIndex));
                        }
                    }
                }
                rows.add(new ResultRow(map));
            }
        }
        catch (SQLException e) {
            if (!e.getMessage().equals("Table not found in statement [SELECT  ClassID, ClassName, TableName FROM Types]") && !e.getMessage().startsWith("Table Types not found")) {
                System.out.println(" exception for query: " + query);
                e.printStackTrace();
            }
            throw new QueryException(e.getMessage());
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    throw new QueryException(e.getMessage());
                }
            }
        }
        return new ResultIteratorImplimentation(rows);
    }

    private String createPreparedSelect(String[] fields, String tableName, Pair[] where, String[] orderBy) {
        StringBuffer sb = new StringBuffer("SELECT ");
        if (fields == null) {
            sb.append("*");
        } else {
            this.append(sb, "", fields, ", ");
        }
        sb.append(" FROM ");
        sb.append(this.formatTableName(tableName));
        if (where != null) {
            sb.append(" WHERE ");
            for (Pair pair : where) {
                sb.append(this.formatField((String)pair.getFirst())).append(" = ? ");
                sb.append(" AND ");
            }
            sb.delete(sb.length() - 5, sb.length());
        }
        this.append(sb, "ORDER BY  ", orderBy, ", ");
        return sb.toString();
    }

    private String createPreparedSelect(String[] fields, String tableName, BasicCondition where, String[] orderBy, Limit limit) {
        StringBuffer sb = new StringBuffer("SELECT ");
        if (fields == null) {
            sb.append("*");
        } else {
            this.append(sb, "", fields, ", ");
        }
        sb.append(" FROM ");
        sb.append(this.formatTableName(tableName));
        if (where != null) {
            sb.append(" WHERE ").append(where.preparedString());
        }
        this.appendOrder(sb, orderBy);
        if (limit != null) {
            this.addLimit(sb, limit);
        }
        return sb.toString();
    }

    private void appendOrder(StringBuffer sb, String[] orderBy) {
        if (orderBy != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < orderBy.length; ++i) {
                String fieldName = "";
                String ascDesc = "";
                if (orderBy[i].endsWith("DESC") || orderBy[i].endsWith("ASC")) {
                    String[] split = orderBy[i].split(" ");
                    fieldName = split[0];
                    ascDesc = " " + split[1];
                } else {
                    fieldName = orderBy[i];
                }
                sb.append(this.formatField(fieldName));
                sb.append(ascDesc);
            }
        }
    }

    private void addLimit(StringBuffer sb, Limit limit) {
        sb.append(" LIMIT ").append(limit.getLimit()).append(" OFFSET  ").append(limit.getOffset());
    }

    private String prepareSelect(String[] fields, String tableName, BasicCondition where, String[] orderBy) {
        StringBuffer sb = new StringBuffer("SELECT ");
        if (fields == null) {
            sb.append("*");
        } else {
            this.append(sb, "", fields, ", ");
        }
        sb.append(" FROM ");
        sb.append(tableName);
        if (where != null) {
            sb.append(" WHERE ").append(where.toString());
        }
        this.append(sb, "ORDER BY  ", orderBy, ", ");
        return sb.toString();
    }

    @Override
    public void deploy() {
        DefaultSqlServer.executeUpdate("CREATE TABLE " + this.formatTableName(this.types) + " (" + this.formatField("ClassID") + " INT IDENTITY)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.formatTableName(this.types) + " ADD COLUMN " + this.formatField("ClassName") + " VARCHAR(200)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.formatTableName(this.types) + " ADD COLUMN " + this.formatField("TableName") + " VARCHAR(50)");
        DefaultSqlServer.executeUpdate("CREATE TABLE " + this.formatTableName(this.fields) + " (" + this.formatField("TypeID1") + " INT NOT NULL)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.formatTableName(this.fields) + " ADD COLUMN " + this.formatField("FieldName") + " VARCHAR(200)");
        DefaultSqlServer.executeUpdate("ALTER TABLE " + this.formatTableName(this.fields) + " ADD COLUMN " + this.formatField("FieldType") + " VARCHAR(200)");
    }

    public String getAutoincrementSyntax() {
        return "IDENTITY";
    }

    private void append(StringBuffer sb, String keyword, Object[] array, String delimiter) {
        if (array != null) {
            sb.append(" ");
            sb.append(keyword);
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                if (o instanceof String) {
                    String s = (String)o;
                    sb.append(this.formatField(s));
                } else if (o instanceof Pair) {
                    Pair pair = (Pair)o;
                    sb.append(this.formatFieldEquals((String)pair.getFirst(), pair.getSecond()));
                } else {
                    throw new PersistenceException("Unable to cast object " + o + " i= " + i);
                }
                if (i + 1 >= array.length) continue;
                sb.append(delimiter);
            }
        }
    }

    private void preparedAppend(StringBuffer sb, String keyword, Object[] array, String delimiter) {
        if (array != null) {
            sb.append(" ");
            sb.append(keyword);
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                if (o instanceof String) {
                    String s = (String)o;
                    sb.append(this.formatField(s));
                } else {
                    Pair pair = (Pair)o;
                    sb.append(this.formatPreparedFieldEquals((String)pair.getFirst()));
                }
                if (i + 1 >= array.length) continue;
                sb.append(delimiter);
            }
        }
    }

    @Override
    public void close() {
        DBConnection.closeConnection();
    }

    @Override
    public String encode(String str) {
        for (String key : target) {
            str = str.replace(key, encodingMap.get(key));
        }
        return str;
    }

    @Override
    public String decode(String str) {
        StringBuffer dest = new StringBuffer();
        StringBuffer source = new StringBuffer(str);
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char chr = source.charAt(i);
            try {
                if (chr == '+') {
                    chr = source.charAt(++i);
                    chr = decodingMap.get(Character.valueOf(chr)).charValue();
                }
            }
            catch (NullPointerException e) {
                dest.append(source.charAt(i - 1));
            }
            dest.append(chr);
        }
        return dest.toString();
    }

    @Override
    public void addUnique(String tableName, String fieldName) {
        String sql = "ALTER TABLE " + this.formatTableName(tableName) + " ADD UNIQUE (" + this.formatField(fieldName) + ")";
        DefaultSqlServer.executeUpdate(sql);
    }

    @Override
    public void addIndex(String tableName, String fieldName) {
        DefaultSqlServer.executeUpdate("CREATE INDEX " + this.formatField(fieldName) + " ON " + this.formatTableName(tableName) + " ( " + this.formatField(fieldName) + " ) ");
    }

    @Override
    public long count(String tableName, BasicCondition where) {
        StringBuffer query = new StringBuffer("SELECT count(*) FROM ");
        query.append(this.formatTableName(tableName));
        if (where != null) {
            query.append(" WHERE ").append(where.preparedString());
        }
        List<String> values = where != null ? where.prepareValues() : new Vector<String>();
        ResultSet rset = null;
        Statement st = null;
        try {
            rset = this.safelyExecuteQuery(query.toString(), values);
            if (rset.next()) {
                long l = rset.getLong(1);
                return l;
            }
            st.close();
        }
        catch (SQLException e) {
            if (!e.getMessage().equals("Table not found in statement [SELECT  ClassID, ClassName, TableName FROM Types]")) {
                System.out.println(" exception for query: " + query);
                e.printStackTrace();
            }
            throw new QueryException(e.getMessage());
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    throw new QueryException(e.getMessage());
                }
            }
        }
        return 0L;
    }

    @Override
    public String getTypeForFloat() {
        return this.getTypeForNumber(25, 3);
    }

    @Override
    public String getTypeForDouble() {
        return this.getTypeForNumber(25, 3);
    }

    static {
        for (int i = 0; i < target.length; ++i) {
            convertionCharset.put(target[i], replace[i]);
        }
        for (String key : target) {
            encodingMap.put(key, "+" + convertionCharset.get(key));
        }
        for (String key : convertionCharset.keySet()) {
            decodingMap.put(Character.valueOf(convertionCharset.get(key).charAt(0)), Character.valueOf(key.charAt(0)));
        }
    }
}

