/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.impl;

import com.jslope.security.crypto.EncryptedBytes;
import com.jslope.security.crypto.JSlopePrivateKey;
import com.jslope.security.crypto.JSlopeSigner;
import com.jslope.security.crypto.SymetricKeyFactory;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.JSlopeDigest;
import com.jslope.security.crypto.impl.RSAKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAPrivateKey
extends RSAKey
implements JSlopeSigner,
JSlopePrivateKey {
    public RSAPrivateKey() {
    }

    public RSAPrivateKey(CipherParameters privateKey) {
        this.key = privateKey;
    }

    public RSAPrivateKey(byte[] publicKeyBytes) {
        this.load(publicKeyBytes);
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        RSAPrivateCrtKeyParameters rsaKey = (RSAPrivateCrtKeyParameters)this.key;
        try {
            aOut.writeObject((Object)new RSAPrivateKeyStructure(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getExponent(), rsaKey.getP(), rsaKey.getQ(), rsaKey.getDP(), rsaKey.getDQ(), rsaKey.getQInv()));
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public void load(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ASN1InputStream as1in = new ASN1InputStream((InputStream)bis);
        try {
            ASN1Sequence asn = (ASN1Sequence)as1in.readObject();
            RSAPrivateKeyStructure structure = new RSAPrivateKeyStructure(asn);
            this.key = new RSAPrivateCrtKeyParameters(structure.getModulus(), structure.getPublicExponent(), structure.getPrivateExponent(), structure.getPrime1(), structure.getPrime2(), structure.getExponent1(), structure.getExponent2(), structure.getCoefficient());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public byte[] sign(byte[] message) throws CryptogException {
        return this.internalEncrypt(JSlopeDigest.digest(message));
    }

    @Override
    public byte[] decrypt(EncryptedBytes encryptedBytes) throws CryptogException {
        byte[] key = this.internalDecrypt(encryptedBytes.getKey());
        return SymetricKeyFactory.decrypt(key, encryptedBytes.getData());
    }

    @Override
    public byte[] decryptLowLevel(byte[] encryptedByte) throws CryptogException {
        return this.internalDecrypt(encryptedByte);
    }
}

